/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IsisNeighborTlv
extends TlvHeader
implements IsisTlv {
    private List<MacAddress> neighbor = new ArrayList<MacAddress>();

    public IsisNeighborTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public void addNeighbor(MacAddress macAddress) {
        this.neighbor.add(macAddress);
    }

    public List<MacAddress> neighbor() {
        return this.neighbor;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 6) {
            byte[] addressbytes = new byte[6];
            channelBuffer.readBytes(addressbytes, 0, 6);
            this.neighbor.add(MacAddress.valueOf((byte[])addressbytes));
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList bytes = new ArrayList();
        for (MacAddress macAddress : this.neighbor) {
            bytes.addAll(Bytes.asList((byte[])macAddress.toBytes()));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("neighbor", this.neighbor).toString();
    }
}

