/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.tlv.MetricsOfReachability;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IsReachabilityTlv
extends TlvHeader {
    private int reserved;
    private List<MetricsOfReachability> metricsOfReachabilities = new ArrayList<MetricsOfReachability>();

    public IsReachabilityTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public int reserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public void addMeticsOfReachability(MetricsOfReachability metricsOfReachability) {
        this.metricsOfReachabilities.add(metricsOfReachability);
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setReserved(channelBuffer.readByte());
        while (channelBuffer.readableBytes() > 0) {
            MetricsOfReachability metricsOfReachability = new MetricsOfReachability();
            metricsOfReachability.readFrom(channelBuffer);
            this.metricsOfReachabilities.add(metricsOfReachability);
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add((byte)this.reserved());
        for (MetricsOfReachability metricsOfReachability : this.metricsOfReachabilities) {
            bytes.addAll(Bytes.asList((byte[])metricsOfReachability.asBytes()));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("metricsOfReachabilities", this.metricsOfReachabilities).toString();
    }
}

