/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;

public class IpInterfaceAddressTlv
extends TlvHeader
implements IsisTlv {
    private List<Ip4Address> interfaceAddress = new ArrayList<Ip4Address>();

    public IpInterfaceAddressTlv(TlvHeader tlvHeader) {
        this.setTlvType(tlvHeader.tlvType());
        this.setTlvLength(tlvHeader.tlvLength());
    }

    public void addInterfaceAddres(Ip4Address interfaceAddress) {
        this.interfaceAddress.add(interfaceAddress);
    }

    public List<Ip4Address> interfaceAddress() {
        return this.interfaceAddress;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        while (channelBuffer.readableBytes() >= 4) {
            byte[] addressbytes = new byte[4];
            channelBuffer.readBytes(addressbytes, 0, 4);
            this.interfaceAddress.add(Ip4Address.valueOf((byte[])addressbytes));
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] bytes = null;
        byte[] tlvHeader = this.tlvHeaderAsByteArray();
        byte[] tlvBody = this.tlvBodyAsBytes();
        tlvHeader[1] = (byte)tlvBody.length;
        bytes = Bytes.concat((byte[][])new byte[][]{tlvHeader, tlvBody});
        return bytes;
    }

    private byte[] tlvBodyAsBytes() {
        ArrayList bytes = new ArrayList();
        for (Ip4Address ip4Address : this.interfaceAddress) {
            bytes.addAll(Bytes.asList((byte[])ip4Address.toOctets()));
        }
        return Bytes.toArray(bytes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("interfaceAddress", this.interfaceAddress).toString();
    }
}

