/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;
import org.onosproject.isis.io.isispacket.tlv.TlvFinder;
import org.onosproject.isis.io.isispacket.tlv.TlvHeader;
import org.onosproject.isis.io.isispacket.tlv.TlvType;
import org.onosproject.isis.io.isispacket.tlv.TlvsToBytes;
import org.onosproject.isis.io.util.IsisUtil;

public class Psnp
extends IsisHeader {
    private int pduLength;
    private String sourceId;
    private List<IsisTlv> variableLengths = new ArrayList<IsisTlv>();

    public Psnp(IsisHeader isisHeader) {
        this.populateHeader(isisHeader);
    }

    public void addTlv(IsisTlv isisTlv) {
        this.variableLengths.add(isisTlv);
    }

    public List<IsisTlv> getAllTlv() {
        return this.variableLengths;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public int pduLength() {
        return this.pduLength;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    @Override
    public void readFrom(ChannelBuffer channelBuffer) {
        this.setPduLength(channelBuffer.readUnsignedShort());
        byte[] tempByteArray = new byte[7];
        channelBuffer.readBytes(tempByteArray, 0, 7);
        this.setSourceId(IsisUtil.systemIdPlus(tempByteArray));
        while (channelBuffer.readableBytes() > 0) {
            TlvHeader tlvHeader = new TlvHeader();
            tlvHeader.setTlvType(channelBuffer.readUnsignedByte());
            tlvHeader.setTlvLength(channelBuffer.readUnsignedByte());
            TlvType tlvValue = TlvType.get(tlvHeader.tlvType());
            if (tlvValue != null) {
                IsisTlv tlv = TlvFinder.findTlv(tlvHeader, channelBuffer.readBytes(tlvHeader.tlvLength()));
                if (tlv == null) continue;
                this.variableLengths.add(tlv);
                continue;
            }
            channelBuffer.readBytes(tlvHeader.tlvLength());
        }
    }

    @Override
    public byte[] asBytes() {
        byte[] psnpMessage = null;
        byte[] isisPduHeader = this.isisPduHeader();
        byte[] psnpBody = this.partialSequenceNumberPduBody();
        psnpMessage = Bytes.concat((byte[][])new byte[][]{isisPduHeader, psnpBody});
        return psnpMessage;
    }

    public byte[] isisPduHeader() {
        ArrayList<Byte> headerList = new ArrayList<Byte>();
        headerList.add(this.irpDiscriminator());
        headerList.add((byte)IsisUtil.getPduHeaderLength(this.pduType()));
        headerList.add(this.version());
        headerList.add(this.idLength());
        headerList.add((byte)this.pduType());
        headerList.add(this.version2());
        headerList.add(this.reserved());
        headerList.add(this.maximumAreaAddresses());
        return Bytes.toArray(headerList);
    }

    public byte[] partialSequenceNumberPduBody() {
        ArrayList<Byte> bodyList = new ArrayList<Byte>();
        bodyList.addAll(Bytes.asList((byte[])IsisUtil.convertToTwoBytes(this.pduLength())));
        bodyList.addAll(IsisUtil.sourceAndLanIdToBytes(this.sourceId()));
        for (IsisTlv isisTlv : this.variableLengths) {
            bodyList.addAll(TlvsToBytes.tlvToBytes(isisTlv));
        }
        return Bytes.toArray(bodyList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("pduLength", this.pduLength).add("sourceId", (Object)this.sourceId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Psnp that = (Psnp)o;
        return Objects.equal((Object)this.pduLength, (Object)that.pduLength);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sourceId, this.pduLength});
    }
}

