/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket.pdu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.isis.controller.IsisInterfaceState;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.tlv.AdjacencyStateTlv;
import org.onosproject.isis.io.isispacket.tlv.AreaAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IpInterfaceAddressTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisNeighborTlv;
import org.onosproject.isis.io.isispacket.tlv.IsisTlv;

public abstract class HelloPdu
extends IsisHeader {
    protected List<IsisTlv> variableLengths = new ArrayList<IsisTlv>();
    private byte circuitType;
    private String sourceId;
    private int holdingTime;
    private int pduLength;

    public void addTlv(IsisTlv isisTlv) {
        this.variableLengths.add(isisTlv);
    }

    public List<IsisTlv> tlvs() {
        return this.variableLengths;
    }

    public List<String> areaAddress() {
        List<String> areaAddresses = null;
        for (IsisTlv tlv : this.tlvs()) {
            if (!(tlv instanceof AreaAddressTlv)) continue;
            areaAddresses = ((AreaAddressTlv)tlv).areaAddress();
        }
        return areaAddresses;
    }

    public List<Ip4Address> interfaceIpAddresses() {
        List<Ip4Address> interfaceIpAddresses = null;
        for (IsisTlv tlv : this.tlvs()) {
            if (!(tlv instanceof IpInterfaceAddressTlv)) continue;
            interfaceIpAddresses = ((IpInterfaceAddressTlv)tlv).interfaceAddress();
        }
        return interfaceIpAddresses;
    }

    public List<MacAddress> neighborList() {
        List<MacAddress> macAddresses = null;
        for (IsisTlv tlv : this.tlvs()) {
            if (!(tlv instanceof IsisNeighborTlv)) continue;
            macAddresses = ((IsisNeighborTlv)tlv).neighbor();
        }
        return macAddresses;
    }

    public IsisInterfaceState adjacencyState() {
        IsisInterfaceState interfaceState = null;
        for (IsisTlv tlv : this.tlvs()) {
            if (!(tlv instanceof AdjacencyStateTlv)) continue;
            interfaceState = IsisInterfaceState.get((int)((AdjacencyStateTlv)tlv).adjacencyType());
            break;
        }
        return interfaceState;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public int pduLength() {
        return this.pduLength;
    }

    public void setPduLength(int pduLength) {
        this.pduLength = pduLength;
    }

    public int holdingTime() {
        return this.holdingTime;
    }

    public void setHoldingTime(int holdingTime) {
        this.holdingTime = holdingTime;
    }

    public byte circuitType() {
        return this.circuitType;
    }

    public void setCircuitType(byte circuitType) {
        this.circuitType = circuitType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("circuitType", (int)this.circuitType).add("sourceId", (Object)this.sourceId).add("holdingTime", this.holdingTime).add("pduLength", this.pduLength).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloPdu that = (HelloPdu)o;
        return Objects.equal((Object)this.circuitType, (Object)that.circuitType) && Objects.equal((Object)this.sourceId, (Object)that.sourceId) && Objects.equal((Object)this.holdingTime, (Object)that.holdingTime) && Objects.equal((Object)this.pduLength, (Object)that.pduLength);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.circuitType, this.sourceId, this.holdingTime, this.pduLength});
    }
}

