/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.io.isispacket;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.isis.controller.IsisMessage;
import org.onosproject.isis.exceptions.IsisParseException;
import org.onosproject.isis.io.isispacket.IsisHeader;
import org.onosproject.isis.io.isispacket.pdu.Csnp;
import org.onosproject.isis.io.isispacket.pdu.L1L2HelloPdu;
import org.onosproject.isis.io.isispacket.pdu.LsPdu;
import org.onosproject.isis.io.isispacket.pdu.P2PHelloPdu;
import org.onosproject.isis.io.isispacket.pdu.Psnp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisMessageReader {
    protected static final Logger log = LoggerFactory.getLogger(IsisMessageReader.class);

    public IsisMessage readFromBuffer(ChannelBuffer channelBuffer) throws Exception {
        int dataLength = channelBuffer.readableBytes();
        log.debug("IsisMessageReader::readFromBuffer Data length {}", (Object)dataLength);
        if (channelBuffer.readableBytes() < 1497) {
            log.debug("Packet should have minimum length...");
            throw new IsisParseException(1, 3);
        }
        IsisHeader isisHeader = this.getIsisHeader(channelBuffer);
        short totalLength = 0;
        IsisHeader isisMessage = null;
        switch (isisHeader.isisPduType()) {
            case L1HELLOPDU: 
            case L2HELLOPDU: {
                isisMessage = new L1L2HelloPdu(isisHeader);
                totalLength = channelBuffer.getShort(17);
                break;
            }
            case P2PHELLOPDU: {
                isisMessage = new P2PHelloPdu(isisHeader);
                totalLength = channelBuffer.getShort(17);
                break;
            }
            case L1LSPDU: 
            case L2LSPDU: {
                isisMessage = new LsPdu(isisHeader);
                totalLength = channelBuffer.getShort(8);
                break;
            }
            case L1CSNP: 
            case L2CSNP: {
                isisMessage = new Csnp(isisHeader);
                totalLength = channelBuffer.getShort(8);
                break;
            }
            case L1PSNP: 
            case L2PSNP: {
                isisMessage = new Psnp(isisHeader);
                totalLength = channelBuffer.getShort(8);
                break;
            }
            default: {
                log.debug("Message Reader[Decoder] - Unknown PDU type..!!!");
            }
        }
        if (isisMessage != null) {
            try {
                int bodyLength = totalLength - 8;
                isisMessage.readFrom(channelBuffer.readBytes(bodyLength));
            }
            catch (Exception e) {
                throw new IsisParseException(2, 4);
            }
        }
        return isisMessage;
    }

    private IsisHeader getIsisHeader(ChannelBuffer channelBuffer) throws Exception {
        IsisHeader isisHeader = new IsisHeader();
        isisHeader.setIrpDiscriminator(channelBuffer.readByte());
        isisHeader.setPduHeaderLength(channelBuffer.readByte());
        isisHeader.setVersion(channelBuffer.readByte());
        isisHeader.setIdLength(channelBuffer.readByte());
        isisHeader.setIsisPduType(channelBuffer.readByte());
        isisHeader.setVersion2(channelBuffer.readByte());
        isisHeader.setReserved(channelBuffer.readByte());
        isisHeader.setMaximumAreaAddresses(channelBuffer.readByte());
        return isisHeader;
    }
}

