/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller;

import org.onosproject.incubator.net.tunnel.Tunnel;

public enum PcepLspStatus {
    DOWN,
    UP,
    ACTIVE,
    GOING_DOWN,
    GOING_UP;


    public static PcepLspStatus getLspStatusFromTunnelStatus(Tunnel.State tunnelState) {
        switch (tunnelState) {
            case INIT: {
                return DOWN;
            }
            case ESTABLISHED: {
                return GOING_UP;
            }
            case ACTIVE: {
                return UP;
            }
        }
        return DOWN;
    }

    public static Tunnel.State getTunnelStatusFromLspStatus(PcepLspStatus lspState) {
        switch (lspState) {
            case DOWN: {
                return Tunnel.State.FAILED;
            }
            case UP: 
            case ACTIVE: {
                return Tunnel.State.ACTIVE;
            }
            case GOING_DOWN: {
                return Tunnel.State.FAILED;
            }
            case GOING_UP: {
                return Tunnel.State.ESTABLISHED;
            }
        }
        return Tunnel.State.FAILED;
    }
}

