/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onlab.packet.IpAddress;
import org.onlab.util.Identifier;

public final class PccId
extends Identifier<IpAddress> {
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;

    private PccId(IpAddress ipAddress) {
        super((Object)ipAddress);
    }

    public static PccId pccId(IpAddress ipAddress) {
        return new PccId(ipAddress);
    }

    public IpAddress ipAddress() {
        return (IpAddress)this.identifier;
    }

    public static PccId pccid(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new PccId(IpAddress.valueOf((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(PccId pccid) {
        return PccId.uri(pccid.ipAddress());
    }

    public static URI uri(IpAddress ipAddress) {
        try {
            return new URI(SCHEME, ipAddress.toString(), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

