/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.config.impl;

import com.google.common.annotations.Beta;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.config.DynamicConfigEvent;
import org.onosproject.config.DynamicConfigListener;
import org.onosproject.config.DynamicConfigService;
import org.onosproject.config.DynamicConfigStore;
import org.onosproject.config.DynamicConfigStoreDelegate;
import org.onosproject.config.FailedException;
import org.onosproject.config.Filter;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.RpcCaller;
import org.onosproject.yang.model.RpcCommand;
import org.onosproject.yang.model.RpcHandler;
import org.onosproject.yang.model.RpcInput;
import org.onosproject.yang.model.RpcOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
@Service
public class DynamicConfigManager
extends AbstractListenerManager<DynamicConfigEvent, DynamicConfigListener>
implements DynamicConfigService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DynamicConfigStoreDelegate storeDelegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DynamicConfigStore store;

    @Activate
    public void activate() {
        this.store.setDelegate(this.storeDelegate);
        this.eventDispatcher.addSink(DynamicConfigEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("DynamicConfigService Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate(this.storeDelegate);
        this.eventDispatcher.removeSink(DynamicConfigEvent.class);
        this.log.info("DynamicConfigService Stopped");
    }

    @Override
    public void createNodeRecursive(ResourceId path, DataNode node) {
        Boolean stat = false;
        stat = this.store.addNode(path, node).join();
    }

    @Override
    public DataNode readNode(ResourceId path, Filter filter) {
        return this.store.readNode(path, filter).join();
    }

    @Override
    public void updateNode(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void deleteNode(ResourceId path) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void deleteNodeRecursive(ResourceId path) {
        this.store.deleteNodeRecursive(path).join();
    }

    @Override
    public void updateNodeRecursive(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void replaceNode(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public Integer getNumberOfChildren(ResourceId path, Filter filter) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void registerHandler(RpcHandler handler, RpcCommand command) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void unRegisterHandler(RpcHandler handler, RpcCommand command) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void invokeRpc(RpcCaller caller, Integer msgId, RpcCommand command, RpcInput input) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public void rpcResponse(Integer msgId, RpcOutput output) {
        throw new FailedException("Not yet implemented");
    }

    protected void bindStore(DynamicConfigStore dynamicConfigStore) {
        this.store = dynamicConfigStore;
    }

    protected void unbindStore(DynamicConfigStore dynamicConfigStore) {
        if (this.store == dynamicConfigStore) {
            this.store = null;
        }
    }

    private class InternalStoreDelegate
    implements DynamicConfigStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(DynamicConfigEvent event) {
            DynamicConfigManager.this.post((Event)event);
        }
    }
}

