/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.config.impl;

import com.google.common.annotations.Beta;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.config.DynamicConfigEvent;
import org.onosproject.config.DynamicConfigStore;
import org.onosproject.config.DynamicConfigStoreDelegate;
import org.onosproject.config.FailedException;
import org.onosproject.config.Filter;
import org.onosproject.config.ResourceIdParser;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeBuilder;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
@Service
public class DistributedDynamicConfigStore
extends AbstractStore<DynamicConfigEvent, DynamicConfigStoreDelegate>
implements DynamicConfigStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AsyncDocumentTree<DataNode.Type> keystore;
    private ConsistentMap<String, LeafNode> objectStore;
    private final DocumentTreeListener<DataNode.Type> klistener = new InternalDocTreeListener();
    private final MapEventListener<String, LeafNode> olistener = new InternalMapListener();

    @Activate
    public void activateStore() {
        KryoNamespace.Builder kryoBuilder = new KryoNamespace.Builder().register(KryoNamespaces.BASIC).register(new Class[]{Class.class}).register(new Class[]{DataNode.Type.class}).register(new Class[]{LeafNode.class}).register(new Class[]{InnerNode.class}).register(new Class[]{ResourceId.class}).register(new Class[]{NodeKey.class}).register(new Class[]{SchemaId.class}).register(new Class[]{LeafListKey.class}).register(new Class[]{ListKey.class}).register(new Class[]{KeyLeaf.class}).register(new Class[]{BigInteger.class}).register(new Class[]{LinkedHashMap.class});
        this.keystore = ((DocumentTreeBuilder)((DocumentTreeBuilder)((DocumentTreeBuilder)this.storageService.documentTreeBuilder().withSerializer(Serializer.using((KryoNamespace)kryoBuilder.build()))).withName("config-key-store")).withRelaxedReadConsistency()).buildDocumentTree();
        this.objectStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)kryoBuilder.build()))).withName("config-object-store")).withRelaxedReadConsistency()).build();
        this.keystore.addListener(this.klistener);
        this.objectStore.addListener(this.olistener);
        this.log.info("DyanmicConfig Store Active");
    }

    @Deactivate
    public void deactivateStore() {
        this.keystore.removeListener(this.klistener);
        this.objectStore.removeListener(this.olistener);
        this.log.info("DyanmicConfig Store Stopped");
    }

    @Override
    public CompletableFuture<Boolean> addNode(ResourceId complete, DataNode node) {
        String spath;
        CompletableFuture<Boolean> eventFuture = CompletableFuture.completedFuture(true);
        List nodeKeyList = complete.nodeKeys();
        NodeKey f = (NodeKey)nodeKeyList.get(0);
        if (f.schemaId().name().compareTo("/") == 0) {
            nodeKeyList.remove(0);
        }
        if ((spath = ResourceIdParser.parseResId(complete)) == null) {
            throw new FailedException("Invalid RsourceId, cannot create Node");
        }
        if (spath.compareTo("root") != 0 && this.completeVersioned(this.keystore.get(DocumentPath.from((String)spath))) == null) {
            throw new FailedException("Node or parent doesnot exist");
        }
        spath = ResourceIdParser.appendNodeKey(spath, node.key());
        this.parseNode(spath, node);
        return eventFuture;
    }

    private void parseNode(String path, DataNode node) {
        if (this.completeVersioned(this.keystore.get(DocumentPath.from((String)path))) != null) {
            throw new FailedException("Requested node already present in the store, please use an update method");
        }
        if (node.type() == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
            this.addLeaf(path, (LeafNode)node);
        } else if (node.type() == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            if (this.completeVersioned(this.keystore.get(DocumentPath.from((String)(path = ResourceIdParser.appendLeafList(path, (LeafListKey)node.key()))))) != null) {
                throw new FailedException("Requested node already present in the store, please use an update method");
            }
            this.addLeaf(path, (LeafNode)node);
        } else if (node.type() == DataNode.Type.SINGLE_INSTANCE_NODE) {
            this.traverseInner(path, (InnerNode)node);
        } else if (node.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
            if (this.completeVersioned(this.keystore.get(DocumentPath.from((String)(path = ResourceIdParser.appendKeyList(path, (ListKey)node.key()))))) != null) {
                throw new FailedException("Requested node already present in the store, please use an update method");
            }
            this.traverseInner(path, (InnerNode)node);
        } else {
            throw new FailedException("Invalid node type");
        }
    }

    private void traverseInner(String path, InnerNode node) {
        this.addKey(path, node.type());
        Map entries = node.childNodes();
        if (entries.size() == 0) {
            return;
        }
        entries.forEach((k, v) -> {
            String tempPath = ResourceIdParser.appendNodeKey(path, v.key());
            if (v.type() == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
                this.addLeaf(tempPath, (LeafNode)v);
            } else if (v.type() == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                tempPath = ResourceIdParser.appendLeafList(tempPath, (LeafListKey)v.key());
                this.addLeaf(tempPath, (LeafNode)v);
            } else if (v.type() == DataNode.Type.SINGLE_INSTANCE_NODE) {
                this.traverseInner(tempPath, (InnerNode)v);
            } else if (v.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
                tempPath = ResourceIdParser.appendKeyList(tempPath, (ListKey)v.key());
                this.traverseInner(tempPath, (InnerNode)v);
            } else {
                throw new FailedException("Invalid node type");
            }
        });
    }

    private Boolean addLeaf(String path, LeafNode node) {
        this.objectStore.put((Object)path, (Object)node);
        return this.addKey(path, node.type());
    }

    private Boolean addKey(String path, DataNode.Type type) {
        Boolean stat = false;
        CompletableFuture ret = this.keystore.create(DocumentPath.from((String)path), (Object)type);
        return (Boolean)this.complete(ret);
    }

    @Override
    public CompletableFuture<DataNode> readNode(ResourceId path, Filter filter) {
        CompletableFuture<Object> eventFuture = CompletableFuture.completedFuture(null);
        List nodeKeyList = path.nodeKeys();
        NodeKey f = (NodeKey)nodeKeyList.get(0);
        if (f.schemaId().name().compareTo("/") == 0) {
            nodeKeyList.remove(0);
        }
        String spath = ResourceIdParser.parseResId(path);
        DocumentPath dpath = DocumentPath.from((String)spath);
        DataNode.Type type = null;
        CompletableFuture ret = this.keystore.get(dpath);
        type = (DataNode.Type)this.completeVersioned(ret);
        if (type == null) {
            throw new FailedException("Requested node or some of the parentsare not present in the requested path");
        }
        LeafNode retVal = null;
        if (type == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
            retVal = this.readLeaf(spath);
        } else if (type == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            retVal = this.readLeaf(spath);
        } else if (type == DataNode.Type.SINGLE_INSTANCE_NODE) {
            NodeKey key = ResourceIdParser.getInstanceKey(path);
            if (key == null) {
                throw new FailedException("Key type did not match node type");
            }
            DataNode.Builder superBldr = InnerNode.builder((String)key.schemaId().name(), (String)key.schemaId().namespace()).type(type);
            this.readInner(superBldr, spath);
            retVal = superBldr.build();
        } else if (type == DataNode.Type.MULTI_INSTANCE_NODE) {
            NodeKey key = ResourceIdParser.getMultiInstanceKey(path);
            if (key == null) {
                throw new FailedException("Key type did not match node type");
            }
            DataNode.Builder superBldr = InnerNode.builder((String)key.schemaId().name(), (String)key.schemaId().namespace()).type(type);
            for (KeyLeaf keyLeaf : ((ListKey)key).keyLeafs()) {
                superBldr.addKeyLeaf(keyLeaf.leafSchema().name(), keyLeaf.leafSchema().namespace(), (Object)String.valueOf(keyLeaf.leafValue()));
            }
            this.readInner(superBldr, spath);
            retVal = superBldr.build();
        } else {
            throw new FailedException("Invalid node type");
        }
        if (retVal != null) {
            eventFuture = CompletableFuture.completedFuture(retVal);
        } else {
            this.log.info("STORE: Failed to READ node");
        }
        return eventFuture;
    }

    private void readInner(DataNode.Builder superBldr, String spath) {
        CompletableFuture ret = this.keystore.getChildren(DocumentPath.from((String)spath));
        Map entries = null;
        entries = (Map)this.complete(ret);
        entries.forEach((k, v) -> {
            String[] names = k.split("\\#");
            String name = names[0];
            String nmSpc = ResourceIdParser.getNamespace(names[1]);
            String keyVal = ResourceIdParser.getKeyVal(names[1]);
            DataNode.Type type = (DataNode.Type)v.value();
            String tempPath = ResourceIdParser.appendNodeKey(spath, name, nmSpc);
            if (type == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
                ((LeafNode.Builder)superBldr.createChildBuilder(name, nmSpc, this.readLeaf(tempPath).value()).type(type)).exitNode();
            } else if (type == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                String mlpath = ResourceIdParser.appendLeafList(tempPath, keyVal);
                LeafNode lfnode = this.readLeaf(mlpath);
                ((LeafNode.Builder)superBldr.createChildBuilder(name, nmSpc, lfnode.value()).type(type)).addLeafListValue(lfnode.value()).exitNode();
            } else if (type == DataNode.Type.SINGLE_INSTANCE_NODE) {
                DataNode.Builder tempBldr = superBldr.createChildBuilder(name, nmSpc).type(type);
                this.readInner(tempBldr, tempPath);
            } else if (type == DataNode.Type.MULTI_INSTANCE_NODE) {
                DataNode.Builder tempBldr = superBldr.createChildBuilder(name, nmSpc).type(type);
                tempPath = ResourceIdParser.appendMultiInstKey(tempPath, k);
                String[] keys = k.split("\\$");
                for (int i = 1; i < keys.length; ++i) {
                    String[] keydata = keys[i].split("\\#");
                    tempBldr.addKeyLeaf(keydata[0], keydata[1], (Object)keydata[2]);
                }
                this.readInner(tempBldr, tempPath);
            } else {
                throw new FailedException("Invalid node type");
            }
        });
        superBldr.exitNode();
    }

    private LeafNode readLeaf(String path) {
        return (LeafNode)this.objectStore.get((Object)path).value();
    }

    @Override
    public CompletableFuture<Boolean> updateNode(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public CompletableFuture<Boolean> updateNodeRecursive(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public CompletableFuture<Boolean> replaceNode(ResourceId path, DataNode node) {
        throw new FailedException("Not yet implemented");
    }

    @Override
    public CompletableFuture<Boolean> deleteNode(ResourceId path) {
        throw new FailedException("Not yet implemented");
    }

    private void deleteInner(String spath) {
        CompletableFuture ret = this.keystore.getChildren(DocumentPath.from((String)spath));
        Map entries = null;
        entries = (Map)this.complete(ret);
        entries.forEach((k, v) -> {
            String[] names = k.split("\\#");
            String name = names[0];
            String nmSpc = ResourceIdParser.getNamespace(names[1]);
            String keyVal = ResourceIdParser.getKeyVal(names[1]);
            DataNode.Type type = (DataNode.Type)v.value();
            String tempPath = ResourceIdParser.appendNodeKey(spath, name, nmSpc);
            if (type == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
                this.removeLeaf(tempPath);
            } else if (type == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                String mlpath = ResourceIdParser.appendLeafList(tempPath, keyVal);
                this.removeLeaf(mlpath);
            } else if (type == DataNode.Type.SINGLE_INSTANCE_NODE) {
                this.deleteInner(tempPath);
            } else if (type == DataNode.Type.MULTI_INSTANCE_NODE) {
                tempPath = ResourceIdParser.appendMultiInstKey(tempPath, k);
                this.deleteInner(tempPath);
            } else {
                throw new FailedException("Invalid node type");
            }
        });
        this.keystore.removeNode(DocumentPath.from((String)spath));
    }

    private void removeLeaf(String path) {
        this.keystore.removeNode(DocumentPath.from((String)path));
        this.objectStore.remove((Object)path);
    }

    @Override
    public CompletableFuture<Boolean> deleteNodeRecursive(ResourceId path) {
        String spath;
        List nodeKeyList = path.nodeKeys();
        NodeKey f = (NodeKey)nodeKeyList.get(0);
        if (f.schemaId().name().compareTo("/") == 0) {
            nodeKeyList.remove(0);
        }
        if ((spath = ResourceIdParser.parseResId(path)) == null) {
            throw new FailedException("Invalid RsourceId, cannot create Node");
        }
        if (spath.compareTo("root") == 0) {
            throw new FailedException("Cannot delete Root");
        }
        DocumentPath dpath = DocumentPath.from((String)spath);
        DataNode.Type type = null;
        CompletableFuture ret = this.keystore.get(dpath);
        type = (DataNode.Type)this.completeVersioned(ret);
        if (type == null) {
            throw new FailedException("Cannot delete, Requested node or some of the parentsare not present in the requested path");
        }
        Object retVal = null;
        if (type == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
            this.removeLeaf(spath);
        } else if (type == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
            this.removeLeaf(spath);
        } else if (type == DataNode.Type.SINGLE_INSTANCE_NODE) {
            this.deleteInner(spath);
        } else if (type == DataNode.Type.MULTI_INSTANCE_NODE) {
            this.deleteInner(spath);
        } else {
            throw new FailedException("Invalid node type");
        }
        return CompletableFuture.completedFuture(true);
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (e == null) {
                throw new FailedException("Unknown Exception");
            }
            throw new FailedException(e.getCause().getMessage());
        }
        catch (ExecutionException e) {
            if (e == null) {
                throw new FailedException("Unknown Exception");
            }
            if (e.getCause() instanceof IllegalDocumentModificationException) {
                throw new FailedException("Node or parent doesnot exist or is root or is not a Leaf Node");
            }
            if (e.getCause() instanceof NoSuchDocumentPathException) {
                throw new FailedException("Resource id does not exist");
            }
            throw new FailedException("Datastore operation failed");
        }
    }

    private <T> T completeVersioned(CompletableFuture<Versioned<T>> future) {
        try {
            if (future.get() != null) {
                return (T)future.get().value();
            }
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FailedException(e.getCause().getMessage());
        }
        catch (ExecutionException e) {
            if (e == null) {
                throw new FailedException("Unknown Exception");
            }
            if (e.getCause() instanceof IllegalDocumentModificationException) {
                throw new FailedException("Node or parent does not exist or is root or is not a Leaf Node");
            }
            if (e.getCause() instanceof NoSuchDocumentPathException) {
                throw new FailedException("Resource id does not exist");
            }
            throw new FailedException("Datastore operation failed");
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    public class InternalMapListener
    implements MapEventListener<String, LeafNode> {
        public void event(MapEvent<String, LeafNode> event) {
            switch (event.type()) {
                case INSERT: {
                    break;
                }
                case UPDATE: {
                    break;
                }
            }
        }
    }

    public class InternalDocTreeListener
    implements DocumentTreeListener<DataNode.Type> {
        public void event(DocumentTreeEvent<DataNode.Type> event) {
            DynamicConfigEvent.Type type;
            switch (event.type()) {
                case CREATED: {
                    type = DynamicConfigEvent.Type.NODE_ADDED;
                    break;
                }
                case UPDATED: {
                    type = DynamicConfigEvent.Type.NODE_UPDATED;
                    break;
                }
                case DELETED: {
                    type = DynamicConfigEvent.Type.NODE_DELETED;
                    break;
                }
                default: {
                    type = DynamicConfigEvent.Type.UNKNOWN_OPRN;
                }
            }
            ResourceId path = ResourceIdParser.getResId(event.path().pathElements());
            DistributedDynamicConfigStore.this.notifyDelegate((Event)new DynamicConfigEvent(type, path));
        }
    }
}

