/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.optical;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.driver.optical.config.FlowTableConfig;
import org.onosproject.driver.optical.config.LambdaConfig;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.driver.AbstractDriverLoader;
import org.onosproject.net.optical.OpticalDevice;

@Component(immediate=true)
public class OpticalDriversLoader
extends AbstractDriverLoader {
    private OpticalDevice optical;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry = new NetworkConfigRegistryAdapter();
    private final List<ConfigFactory> factories = ImmutableList.of((Object)new ConfigFactory<DeviceId, FlowTableConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, FlowTableConfig.class, "flowtable"){

        public FlowTableConfig createConfig() {
            return new FlowTableConfig();
        }
    }, (Object)new ConfigFactory<ConnectPoint, LambdaConfig>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, LambdaConfig.class, "lambdas"){

        public LambdaConfig createConfig() {
            return new LambdaConfig();
        }
    });

    public OpticalDriversLoader() {
        super("/optical-drivers.xml");
    }

    @Activate
    protected void activate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).registerConfigFactory(arg_0));
        super.activate();
    }

    @Deactivate
    protected void deactivate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).unregisterConfigFactory(arg_0));
        super.deactivate();
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }
}

