/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Spectrum;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

public class OplinkSwitchLambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    public Set<OchSignal> queryLambdas(PortNumber port) {
        long startSpacingMultiplier = Spectrum.U_BAND_MIN.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz();
        long stopSpacingMultiplier = Spectrum.O_BAND_MAX.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz();
        return (Set)IntStream.rangeClosed((int)startSpacingMultiplier, (int)stopSpacingMultiplier).mapToObj(x -> new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, x, 1)).collect(GuavaCollectors.toImmutableSet());
    }
}

