/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Spectrum;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

public class OplinkEdfaLambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    private long startSpacingMultiplier = Spectrum.C_BAND_MIN.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz();
    private long stopSpacingMultiplier = Spectrum.C_BAND_MAX.subtract(Spectrum.CENTER_FREQUENCY).asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz();

    public Set<OchSignal> queryLambdas(PortNumber port) {
        return (Set)IntStream.rangeClosed((int)this.startSpacingMultiplier, (int)this.stopSpacingMultiplier).mapToObj(x -> new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, x, 1)).collect(GuavaCollectors.toImmutableSet());
    }
}

