/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import java.util.Collections;
import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.util.GuavaCollectors;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.behaviour.TributarySlotQuery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTributarySlotQuery
extends AbstractHandlerBehaviour
implements TributarySlotQuery {
    private static final Logger log = LoggerFactory.getLogger(DefaultTributarySlotQuery.class);
    private static final int TOTAL_ODU2_TRIBUTARY_SLOTS = 8;
    private static final int TOTAL_ODU4_TRIBUTARY_SLOTS = 80;
    private static final Set<TributarySlot> ENTIRE_ODU2_TRIBUTARY_SLOTS = DefaultTributarySlotQuery.getEntireOdu2TributarySlots();
    private static final Set<TributarySlot> ENTIRE_ODU4_TRIBUTARY_SLOTS = DefaultTributarySlotQuery.getEntireOdu4TributarySlots();

    private static Set<TributarySlot> getEntireOdu2TributarySlots() {
        return (Set)IntStream.rangeClosed(1, 8).mapToObj(TributarySlot::of).collect(GuavaCollectors.toImmutableSet());
    }

    private static Set<TributarySlot> getEntireOdu4TributarySlots() {
        return (Set)IntStream.rangeClosed(1, 80).mapToObj(TributarySlot::of).collect(GuavaCollectors.toImmutableSet());
    }

    public Set<TributarySlot> queryTributarySlots(PortNumber port) {
        OpticalDeviceServiceView deviceService = OpticalDeviceServiceView.opticalView((DeviceService)((DeviceService)this.handler().get(DeviceService.class)));
        Port p = deviceService.getPort(this.data().deviceId(), port);
        if (p == null) {
            return Collections.emptySet();
        }
        switch (p.type()) {
            case OCH: {
                return this.queryOchTributarySlots(p);
            }
            case OTU: {
                return this.queryOtuTributarySlots(p);
            }
        }
        return Collections.emptySet();
    }

    private Set<TributarySlot> queryOchTributarySlots(Port ochPort) {
        OduSignalType signalType = null;
        if (!(ochPort instanceof OchPort)) {
            log.warn("{} was not an OchPort", (Object)ochPort);
            return Collections.emptySet();
        }
        signalType = ((OchPort)ochPort).signalType();
        switch (signalType) {
            case ODU2: {
                return ENTIRE_ODU2_TRIBUTARY_SLOTS;
            }
            case ODU4: {
                return ENTIRE_ODU4_TRIBUTARY_SLOTS;
            }
        }
        log.error("Unsupported signal type {} for {}", (Object)signalType, (Object)ochPort);
        return Collections.emptySet();
    }

    private Set<TributarySlot> queryOtuTributarySlots(Port otuPort) {
        OtuSignalType signalType = null;
        if (!(otuPort instanceof OtuPort)) {
            log.warn("{} was not an OtuPort", (Object)otuPort);
            return Collections.emptySet();
        }
        signalType = ((OtuPort)otuPort).signalType();
        switch (signalType) {
            case OTU2: {
                return ENTIRE_ODU2_TRIBUTARY_SLOTS;
            }
            case OTU4: {
                return ENTIRE_ODU4_TRIBUTARY_SLOTS;
            }
        }
        log.error("Unsupported signal type {} for {}", (Object)signalType, (Object)otuPort);
        return Collections.emptySet();
    }
}

