/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.query;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.onosproject.driver.optical.config.LambdaConfig;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ElementId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    private static final Logger log = LoggerFactory.getLogger(ConfigLambdaQuery.class);

    public Set<OchSignal> queryLambdas(PortNumber port) {
        ConnectPoint cp;
        NetworkConfigService netcfg = (NetworkConfigService)this.handler().get(NetworkConfigService.class);
        LambdaConfig cfg = (LambdaConfig)netcfg.getConfig((Object)(cp = new ConnectPoint((ElementId)this.data().deviceId(), port)), LambdaConfig.class);
        if (cfg == null) {
            return ImmutableSet.of();
        }
        GridType type = cfg.gridType();
        Optional<ChannelSpacing> dwdmSpacing = cfg.dwdmSpacing();
        int start = cfg.slotStart();
        int step = cfg.slotStep();
        int end = cfg.slotEnd();
        LinkedHashSet<OchSignal> lambdas = new LinkedHashSet<OchSignal>();
        block4: for (int i = start; i <= end; i += step) {
            switch (type) {
                case DWDM: {
                    lambdas.add(OchSignal.newDwdmSlot((ChannelSpacing)dwdmSpacing.get(), (int)i));
                    continue block4;
                }
                case FLEX: {
                    lambdas.add(OchSignal.newFlexGridSlot((int)i));
                    continue block4;
                }
                default: {
                    log.warn("Unsupported grid type: {}", (Object)type);
                }
            }
        }
        return lambdas;
    }
}

