/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.protection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.behaviour.protection.ProtectionConfigBehaviour;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointId;
import org.onosproject.net.behaviour.protection.TransportEndpointState;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.link.LinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkSwitchProtection
extends AbstractHandlerBehaviour
implements ProtectionConfigBehaviour {
    private static final int VIRTUAL_PORT = 0;
    private static final int PRIMARY_PORT = 1;
    private static final int SECONDARY_PORT = 2;
    private static final int CLIENT_PORT = 3;
    private static final int FLOWRULE_PRIORITY = 88;
    private static final String PRIMARY_ID = "primary_port";
    private static final String SECONDARY_ID = "secondary_port";
    private static final String OPLINK_FINGERPRINT = "OplinkOPS";
    private static final String APP_ID = "org.onosproject.drivers.optical";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CompletableFuture<ConnectPoint> createProtectionEndpoint(ProtectedTransportEndpointDescription configuration) {
        CompletableFuture<ConnectPoint> result = new CompletableFuture<ConnectPoint>();
        this.addFlow(PortNumber.portNumber((long)0L));
        this.addLinkToPeer(configuration.peer());
        result.complete(new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L)));
        return result;
    }

    public CompletableFuture<ConnectPoint> updateProtectionEndpoint(ConnectPoint identifier, ProtectedTransportEndpointDescription configuration) {
        this.log.warn("Update protection configuration is not supported by this device");
        CompletableFuture<ConnectPoint> result = new CompletableFuture<ConnectPoint>();
        result.complete(new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L)));
        return result;
    }

    public CompletableFuture<Boolean> deleteProtectionEndpoint(ConnectPoint identifier) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (identifier.port().toLong() == 0L) {
            this.removeLinkToPeer(this.getPeerId());
            this.deleteFlow();
            result.complete(true);
        } else {
            result.complete(false);
        }
        return result;
    }

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointDescription>> getProtectionEndpointConfigs() {
        ConnectPoint cp = new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L));
        HashMap<ConnectPoint, ProtectedTransportEndpointDescription> protectedGroups = new HashMap<ConnectPoint, ProtectedTransportEndpointDescription>();
        CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointDescription>> result = new CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointDescription>>();
        protectedGroups.put(cp, this.getProtectedTransportEndpointDescription());
        result.complete(protectedGroups);
        return result;
    }

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointState>> getProtectionEndpointStates() {
        ConnectPoint cp = new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L));
        HashMap<ConnectPoint, ProtectedTransportEndpointState> protectedGroups = new HashMap<ConnectPoint, ProtectedTransportEndpointState>();
        CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointState>> result = new CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointState>>();
        protectedGroups.put(cp, this.getProtectedTransportEndpointState());
        result.complete(protectedGroups);
        return result;
    }

    public CompletableFuture<Void> switchWorkingPath(ConnectPoint identifier, int index) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (identifier.port().toLong() == 0L) {
            this.deleteFlow();
            this.addFlow(PortNumber.portNumber((long)index));
            result.complete((Void)((Object)Boolean.valueOf(true)));
        } else {
            result.complete((Void)((Object)Boolean.valueOf(false)));
        }
        return result;
    }

    private ProtectedTransportEndpointDescription getProtectedTransportEndpointDescription() {
        ArrayList<TransportEndpointDescription> teds = new ArrayList<TransportEndpointDescription>();
        FilteredConnectPoint fcpPrimary = new FilteredConnectPoint(new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)1L)));
        FilteredConnectPoint fcpSecondary = new FilteredConnectPoint(new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)2L)));
        TransportEndpointDescription tedPrimary = TransportEndpointDescription.builder().withOutput(fcpPrimary).build();
        TransportEndpointDescription tedSecondary = TransportEndpointDescription.builder().withOutput(fcpSecondary).build();
        teds.add(tedPrimary);
        teds.add(tedSecondary);
        return ProtectedTransportEndpointDescription.of(teds, (DeviceId)this.getPeerId(), (String)OPLINK_FINGERPRINT);
    }

    private Map<String, String> getProtectionStateAttributes(PortNumber portNumber) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Port port = ((DeviceService)this.handler().get(DeviceService.class)).getPort(this.data().deviceId(), portNumber);
        if (port != null) {
            String portStatus = port.annotations().value("inputStatus");
            attributes.put("inputStatus", portStatus);
        }
        return attributes;
    }

    private int getActivePort() {
        Port port = ((DeviceService)this.handler().get(DeviceService.class)).getPort(this.data().deviceId(), PortNumber.portNumber((long)1L));
        if (port != null && port.annotations().value("inputStatus").equals("inService")) {
            return 1;
        }
        return 2;
    }

    private int getActiveIndex(List<TransportEndpointState> pathStates) {
        long activePort = this.getActivePort();
        int activeIndex = 0;
        for (TransportEndpointState state : pathStates) {
            if (state.description().output().connectPoint().port().toLong() == activePort) {
                return activeIndex;
            }
            ++activeIndex;
        }
        return -1;
    }

    private ProtectedTransportEndpointState getProtectedTransportEndpointState() {
        ArrayList<TransportEndpointState> tess = new ArrayList<TransportEndpointState>();
        PortNumber portPrimary = PortNumber.portNumber((long)1L);
        PortNumber portSecondary = PortNumber.portNumber((long)2L);
        FilteredConnectPoint fcpPrimary = new FilteredConnectPoint(new ConnectPoint((ElementId)this.data().deviceId(), portPrimary));
        FilteredConnectPoint fcpSecondary = new FilteredConnectPoint(new ConnectPoint((ElementId)this.data().deviceId(), portSecondary));
        TransportEndpointDescription tedPrimary = TransportEndpointDescription.builder().withOutput(fcpPrimary).build();
        TransportEndpointDescription tedSecondary = TransportEndpointDescription.builder().withOutput(fcpSecondary).build();
        TransportEndpointState tesPrimary = TransportEndpointState.builder().withDescription(tedPrimary).withId(TransportEndpointId.of((String)PRIMARY_ID)).addAttributes(this.getProtectionStateAttributes(portPrimary)).build();
        TransportEndpointState tesSecondary = TransportEndpointState.builder().withDescription(tedSecondary).withId(TransportEndpointId.of((String)SECONDARY_ID)).addAttributes(this.getProtectionStateAttributes(portSecondary)).build();
        tess.add(tesPrimary);
        tess.add(tesSecondary);
        return ProtectedTransportEndpointState.builder().withDescription(this.getProtectedTransportEndpointDescription()).withPathStates(tess).withActivePathIndex(this.getActiveIndex(tess)).build();
    }

    private void addFlow(PortNumber workingPort) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(workingPort).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)3L)).build();
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.data().deviceId()).fromApp(((CoreService)this.handler().get(CoreService.class)).getAppId(APP_ID)).withPriority(88).withSelector(selector).withTreatment(treatment).makePermanent().build();
        ((FlowRuleService)this.handler().get(FlowRuleService.class)).applyFlowRules(new FlowRule[]{flowRule});
    }

    private void deleteFlow() {
        ((FlowRuleService)this.handler().get(FlowRuleService.class)).purgeFlowRules(this.data().deviceId());
    }

    private void addLinkToPeer(DeviceId peerId) {
        if (peerId == null) {
            this.log.warn("PeerID is null for device {}", (Object)this.data().deviceId());
            return;
        }
        ConnectPoint dstCp = new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L));
        ConnectPoint srcCp = new ConnectPoint((ElementId)peerId, PortNumber.portNumber((long)0L));
        LinkKey link = LinkKey.linkKey((ConnectPoint)srcCp, (ConnectPoint)dstCp);
        BasicLinkConfig cfg = (BasicLinkConfig)((NetworkConfigService)this.handler().get(NetworkConfigService.class)).addConfig((Object)link, BasicLinkConfig.class);
        cfg.type(Link.Type.VIRTUAL);
        cfg.apply();
    }

    private void removeLinkToPeer(DeviceId peerId) {
        if (peerId == null) {
            this.log.warn("PeerID is null for device {}", (Object)this.data().deviceId());
            return;
        }
        ConnectPoint dstCp = new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L));
        ConnectPoint srcCp = new ConnectPoint((ElementId)peerId, PortNumber.portNumber((long)0L));
        LinkKey link = LinkKey.linkKey((ConnectPoint)srcCp, (ConnectPoint)dstCp);
        ((NetworkConfigService)this.handler().get(NetworkConfigService.class)).removeConfig((Object)link, BasicLinkConfig.class);
    }

    private DeviceId getPeerId() {
        ConnectPoint dstCp = new ConnectPoint((ElementId)this.data().deviceId(), PortNumber.portNumber((long)0L));
        Set links = ((LinkService)this.handler().get(LinkService.class)).getIngressLinks(dstCp);
        for (Link l : links) {
            if (l.type() != Link.Type.VIRTUAL) continue;
            return l.src().deviceId();
        }
        return this.data().deviceId();
    }
}

