/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.power;

import com.google.common.collect.Range;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.onosproject.driver.extensions.OplinkAttenuation;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Direction;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkPowerConfigUtil {
    private HandlerBehaviour behaviour;
    private final AtomicInteger xidCounter = new AtomicInteger(0);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long EDFA_POWER_IN_WEST_LOW_THRES = -1900L;
    private static final long EDFA_POWER_IN_WEST_HIGH_THRES = 0L;
    private static final long EDFA_POWER_IN_EAST_LOW_THRES = -3100L;
    private static final long EDFA_POWER_IN_EAST_HIGH_THRES = 700L;
    private static final long EDFA_POWER_OUT_LOW_THRES = 0L;
    private static final long EDFA_POWER_OUT_HIGH_THRES = 1900L;
    private static final long ROADM_POWER_LINE_IN_LOW_THRES = -3000L;
    private static final long ROADM_POWER_LINE_IN_HIGH_THRES = 2350L;
    private static final long ROADM_POWER_LINE_OUT_LOW_THRES = 0L;
    private static final long ROADM_POWER_LINE_OUT_HIGH_THRES = 2350L;
    private static final long ROADM_POWER_OTHER_IN_LOW_THRES = -1500L;
    private static final long ROADM_POWER_OTHER_IN_HIGH_THRES = 2000L;
    private static final long ROADM_POWER_OTHER_OUT_LOW_THRES = -600L;
    private static final long ROADM_POWER_OTHER_OUT_HIGH_THRES = 1500L;
    private static final long ROADM_MIN_ATTENUATION = 0L;
    private static final long ROADM_MAX_ATTENUATION = 2500L;
    private static final long SWITCH_POWER_LOW_THRES = -6000L;
    private static final long SWITCH_POWER_HIGH_THRES = 6000L;

    public OplinkPowerConfigUtil(HandlerBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public Long getTargetPower(PortNumber port, Object component) {
        switch (this.getComponentType(component)) {
            case PORT: {
                return this.getPortPower(port, "targetPower");
            }
            case CHANNEL: {
                return this.getChannelAttenuation(port, (OchSignal)component);
            }
        }
        return null;
    }

    public Long getCurrentPower(PortNumber port, Object component) {
        switch (this.getComponentType(component)) {
            case PORT: {
                return this.getPortPower(port, "currentPower");
            }
            case CHANNEL: {
                return this.getCurrentChannelPower(port, (OchSignal)component);
            }
        }
        return null;
    }

    public void setTargetPower(PortNumber port, Object component, long power) {
        switch (this.getComponentType(component)) {
            case PORT: {
                this.setPortPower(port, power);
                break;
            }
            case CHANNEL: {
                this.setChannelAttenuation(port, (OchSignal)component, power);
                break;
            }
        }
    }

    public Range<Long> getTargetPowerRange(PortNumber port, Object component) {
        switch (this.getComponentType(component)) {
            case PORT: {
                return this.getTargetPortPowerRange(port);
            }
            case CHANNEL: {
                return this.getChannelAttenuationRange(port);
            }
        }
        return null;
    }

    public Range<Long> getInputPowerRange(PortNumber port, Object component) {
        switch (this.getComponentType(component)) {
            case PORT: {
                return this.getInputPortPowerRange(port);
            }
        }
        return null;
    }

    private ComponentType getComponentType(Object component) {
        if (component == null || component instanceof Direction) {
            return ComponentType.PORT;
        }
        if (component instanceof OchSignal) {
            return ComponentType.CHANNEL;
        }
        return ComponentType.NONE;
    }

    private OpenFlowSwitch getOpenFlowDevice() {
        Dpid dpid;
        DriverHandler handler = this.behaviour.handler();
        OpenFlowController controller = (OpenFlowController)handler.get(OpenFlowController.class);
        OpenFlowSwitch sw = controller.getSwitch(dpid = Dpid.dpid((URI)handler.data().deviceId().uri()));
        if (sw == null || !sw.isConnected()) {
            this.log.warn("OpenFlow handshaker driver not found or device is not connected, dpid = {}", (Object)dpid);
            return null;
        }
        return sw;
    }

    private PortDescType getPortDescType(OpenFlowOpticalSwitch opsw, PortNumber portNum) {
        for (PortDescPropertyType type : opsw.getPortTypes()) {
            List portsOf = opsw.getPortsOf(type);
            for (OFObject op : portsOf) {
                OFPortOptical opticalPort;
                if (!(op instanceof OFPortOptical) || (long)(opticalPort = (OFPortOptical)op).getPortNo().getPortNumber() != portNum.toLong()) continue;
                return PortDescType.values()[((OFPortDescPropOpticalTransport)opticalPort.getDesc().get(0)).getPortType()];
            }
        }
        return PortDescType.NONE;
    }

    private Range<Long> getTargetPortPowerRange(PortNumber portNum) {
        OpenFlowSwitch ofs = this.getOpenFlowDevice();
        if (ofs == null) {
            return null;
        }
        PortDescType portType = this.getPortDescType((OpenFlowOpticalSwitch)ofs, portNum);
        Device.Type devType = ofs.deviceType();
        switch (devType) {
            case OPTICAL_AMPLIFIER: {
                if (portType != PortDescType.PA_LINE_OUT && portType != PortDescType.BA_LINE_OUT) break;
                return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1900L));
            }
            case ROADM: {
                if (portType == PortDescType.PA_LINE_OUT) {
                    return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(2350L));
                }
                if (portType != PortDescType.EXP_OUT && portType != PortDescType.AUX_OUT) break;
                return Range.closed((Comparable)Long.valueOf(-600L), (Comparable)Long.valueOf(1500L));
            }
            case FIBER_SWITCH: {
                return Range.closed((Comparable)Long.valueOf(-6000L), (Comparable)Long.valueOf(6000L));
            }
            default: {
                this.log.warn("Unexpected device type: {}", (Object)devType);
            }
        }
        return null;
    }

    private Range<Long> getInputPortPowerRange(PortNumber portNum) {
        OpenFlowSwitch ofs = this.getOpenFlowDevice();
        if (ofs == null) {
            return null;
        }
        PortDescType portType = this.getPortDescType((OpenFlowOpticalSwitch)ofs, portNum);
        Device.Type devType = ofs.deviceType();
        switch (devType) {
            case OPTICAL_AMPLIFIER: {
                if (portType == PortDescType.PA_LINE_IN) {
                    return Range.closed((Comparable)Long.valueOf(-1900L), (Comparable)Long.valueOf(0L));
                }
                if (portType != PortDescType.BA_LINE_IN) break;
                return Range.closed((Comparable)Long.valueOf(-3100L), (Comparable)Long.valueOf(700L));
            }
            case ROADM: {
                if (portType == PortDescType.PA_LINE_IN) {
                    return Range.closed((Comparable)Long.valueOf(-3000L), (Comparable)Long.valueOf(2350L));
                }
                if (portType != PortDescType.EXP_IN && portType != PortDescType.AUX_IN) break;
                return Range.closed((Comparable)Long.valueOf(-1500L), (Comparable)Long.valueOf(2000L));
            }
            case FIBER_SWITCH: {
                return Range.closed((Comparable)Long.valueOf(-6000L), (Comparable)Long.valueOf(6000L));
            }
            default: {
                this.log.warn("Unexpected device type: {}", (Object)devType);
            }
        }
        return null;
    }

    private Range<Long> getChannelAttenuationRange(PortNumber portNum) {
        OpenFlowSwitch ofs = this.getOpenFlowDevice();
        if (ofs == null) {
            return null;
        }
        if (ofs.deviceType() != Device.Type.ROADM) {
            return null;
        }
        PortDescType portType = this.getPortDescType((OpenFlowOpticalSwitch)ofs, portNum);
        if (portType == PortDescType.PA_LINE_OUT || portType == PortDescType.EXP_IN || portType == PortDescType.AUX_IN) {
            return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(2500L));
        }
        return null;
    }

    private Long getPortPower(PortNumber portNum, String annotation) {
        if (this.getOpenFlowDevice() == null) {
            return null;
        }
        DriverHandler handler = this.behaviour.handler();
        DeviceService deviceService = (DeviceService)handler.get(DeviceService.class);
        Port port = deviceService.getPort(handler.data().deviceId(), portNum);
        if (port == null) {
            this.log.warn("Unexpected port: {}", (Object)portNum);
            return null;
        }
        String power = port.annotations().value(annotation);
        if (power == null) {
            this.log.debug("Cannot get {} from port {}.", (Object)annotation, (Object)portNum);
            return null;
        }
        return Long.valueOf(power);
    }

    private void setPortPower(PortNumber portNum, long power) {
        OpenFlowSwitch device = this.getOpenFlowDevice();
        if (device == null) {
            return;
        }
        device.sendMsg((OFMessage)device.factory().buildOplinkPortPowerSet().setXid((long)this.xidCounter.getAndIncrement()).setPort((int)portNum.toLong()).setPowerValue((int)power).build());
    }

    private Long getChannelAttenuation(PortNumber portNum, OchSignal och) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry == null) {
            return null;
        }
        List instructions = flowEntry.treatment().allInstructions();
        for (Instruction ins : instructions) {
            ExtensionTreatment ext;
            if (ins.type() != Instruction.Type.EXTENSION || (ext = ((Instructions.ExtensionInstructionWrapper)ins).extensionInstruction()).type() != ExtensionTreatmentType.ExtensionTreatmentTypes.OPLINK_ATTENUATION.type()) continue;
            return ((OplinkAttenuation)ext).getAttenuation();
        }
        return null;
    }

    private void setChannelAttenuation(PortNumber portNum, OchSignal och, long power) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry == null) {
            this.log.warn("Target channel power not set");
            return;
        }
        DriverHandler handler = this.behaviour.handler();
        for (Instruction ins : flowEntry.treatment().allInstructions()) {
            ExtensionTreatment ext;
            if (ins.type() != Instruction.Type.EXTENSION || (ext = ((Instructions.ExtensionInstructionWrapper)ins).extensionInstruction()).type() != ExtensionTreatmentType.ExtensionTreatmentTypes.OPLINK_ATTENUATION.type()) continue;
            ((OplinkAttenuation)ext).setAttenuation((int)power);
            FlowRuleService service = (FlowRuleService)handler.get(FlowRuleService.class);
            service.applyFlowRules(new FlowRule[]{flowEntry});
            return;
        }
        this.addAttenuation(flowEntry, power);
    }

    private Long getCurrentChannelPower(PortNumber portNum, OchSignal och) {
        FlowEntry flowEntry = this.findFlow(portNum, och);
        if (flowEntry != null) {
            return flowEntry.packets();
        }
        return null;
    }

    private FlowEntry findFlow(PortNumber portNum, OchSignal och) {
        DriverHandler handler = this.behaviour.handler();
        FlowRuleService service = (FlowRuleService)handler.get(FlowRuleService.class);
        Iterable flowEntries = service.getFlowEntries(handler.data().deviceId());
        for (FlowEntry entry : flowEntries) {
            TrafficSelector selector = entry.selector();
            OchSignalCriterion entrySigid = (OchSignalCriterion)selector.getCriterion(Criterion.Type.OCH_SIGID);
            if (entrySigid == null || !och.equals((Object)entrySigid.lambda())) continue;
            PortCriterion entryPort = (PortCriterion)selector.getCriterion(Criterion.Type.IN_PORT);
            if (entryPort != null && portNum.equals((Object)entryPort.port())) {
                return entry;
            }
            TrafficTreatment treatment = entry.treatment();
            for (Instruction instruction : treatment.allInstructions()) {
                if (instruction.type() != Instruction.Type.OUTPUT || !((Instructions.OutputInstruction)instruction).port().equals((Object)portNum)) continue;
                return entry;
            }
        }
        this.log.warn("No matching flow found");
        return null;
    }

    private void addAttenuation(FlowEntry flowEntry, long power) {
        FlowRule.Builder flowBuilder = new DefaultFlowRule.Builder().withCookie(flowEntry.id().value()).withPriority(flowEntry.priority()).forDevice(flowEntry.deviceId()).forTable(flowEntry.tableId());
        if (flowEntry.isPermanent()) {
            flowBuilder.makePermanent();
        } else {
            flowBuilder.makeTemporary(flowEntry.timeout());
        }
        flowBuilder.withSelector(flowEntry.selector());
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        flowEntry.treatment().allInstructions().forEach(ins -> treatmentBuilder.add(ins));
        DriverHandler handler = this.behaviour.handler();
        treatmentBuilder.add((Instruction)Instructions.extension((ExtensionTreatment)new OplinkAttenuation((int)power), (DeviceId)handler.data().deviceId()));
        flowBuilder.withTreatment(treatmentBuilder.build());
        FlowRuleService service = (FlowRuleService)handler.get(FlowRuleService.class);
        service.applyFlowRules(new FlowRule[]{flowBuilder.build()});
    }

    private static enum PortDescType {
        NONE,
        PA_LINE_IN,
        PA_LINE_OUT,
        BA_LINE_IN,
        BA_LINE_OUT,
        EXP_IN,
        EXP_OUT,
        AUX_IN,
        AUX_OUT;

    }

    private static enum ComponentType {
        NONE,
        PORT,
        CHANNEL;

    }
}

