/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.Port;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFCalientPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFCalientPortStatsRequest;
import org.projectfloodlight.openflow.protocol.OFCalientStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;

public class OplinkSwitchHandshaker
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private static final String PROTECTION_FINGERPRINT = "OplinkOPS";
    private static final int PROTECTION_VIRTUAL_PORT = 0;
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private List<OFCalientPortDescStatsEntry> opticalPorts = new ArrayList<OFCalientPortDescStatsEntry>();

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        this.log.info("OPLK Switch: Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        this.log.debug("OPLK Switch: sendHandshakeOFExperimenterPortDescRequest for sw {}", (Object)this.getStringId());
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("OPLK Switch: exception while sending experimenter port desc:", (Throwable)e);
        }
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        this.log.info("OPLK Switch: processDriverHandshakeMessage for sw {}", (Object)this.getStringId());
        switch (m.getType()) {
            case STATS_REPLY: {
                this.processOFMultipartReply((OFStatsReply)m);
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("OPLK Switch: Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    public final void sendMsg(OFMessage m) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(m);
        if (m.getType() == OFType.STATS_REQUEST) {
            OFStatsRequest sr = (OFStatsRequest)m;
            this.log.debug("OPLK Switch: Rebuilding stats request type {}", (Object)sr.getStatsType());
            switch (sr.getStatsType()) {
                case PORT: {
                    OFCalientPortStatsRequest portRequest = this.factory().buildCalientPortStatsRequest().setXid(sr.getXid()).setFlags(sr.getFlags()).build();
                    messages.add(portRequest);
                    break;
                }
            }
        } else {
            this.log.debug("OPLK Switch: sends msg:{}, as is", (Object)m.getType());
        }
        super.sendMsg(messages);
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCalientPortDescStatsRequest preq = this.factory().buildCalientPortDescStatsRequest().setXid((long)this.getNextTransactionId()).build();
        this.log.info("OPLK Switch: Sending experimented port description message {}", (Object)preq);
        this.sendHandshakeMessage((OFMessage)preq);
    }

    public Device.Type deviceType() {
        return Device.Type.FIBER_SWITCH;
    }

    public List<OFPortDesc> getPorts() {
        return ImmutableList.copyOf((Collection)this.ports.stream().flatMap(p -> p.getEntries().stream()).collect(Collectors.toList()));
    }

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        return ImmutableList.copyOf(this.opticalPorts);
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }

    public List<PortDescription> processExpPortStats(OFMessage msg) {
        OFCalientStatsReply statsReply = (OFCalientStatsReply)msg;
        SubType type = SubType.values()[(int)statsReply.getSubtype() - 1];
        switch (type) {
            case PORT_STATS: {
                OFCalientPortStatsReply portStats = (OFCalientPortStatsReply)msg;
                return this.buildPortDescriptions(portStats.getEntries());
            }
        }
        this.log.warn("OPLK Switch: Received message {} from switch {} ... Ignoring message", (Object)msg, (Object)this.getStringId());
        return null;
    }

    private List<PortDescription> buildPortDescriptions(List<OFCalientPortStatsEntry> entries) {
        DeviceService deviceService = (DeviceService)this.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.data().deviceId());
        HashMap statsMap = new HashMap(entries.size());
        entries.forEach(entry -> statsMap.put(Long.valueOf(entry.getPortNo().getPortNumber()), entry));
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (Port port : ports) {
            OFCalientPortStatsEntry entry2;
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            builder.putAll(port.annotations());
            if (port.number().toLong() == 0L) {
                builder.set("protection:fingerprint", PROTECTION_FINGERPRINT);
            }
            if ((entry2 = (OFCalientPortStatsEntry)statsMap.get(port.number().toLong())) == null) continue;
            builder.set("currentPower", entry2.getInportPower());
            builder.set("ouputPower", entry2.getOutportPower());
            if (entry2.getInOperStatus().isEmpty()) {
                builder.set("inputStatus", "inService");
            } else {
                builder.set("inputStatus", "outOfService");
            }
            if (entry2.getOutOperStatus().isEmpty()) {
                builder.set("ouputStatus", "inService");
            } else {
                builder.set("ouputStatus", "outOfService");
            }
            portDescs.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{builder.build()}));
        }
        return portDescs;
    }

    private void processOFMultipartReply(OFStatsReply stats) {
        this.log.debug("OPLK Switch: Received message {} during switch-driver subhandshake from switch {} ... ", (Object)stats, (Object)this.getStringId());
        if (stats.getStatsType() == OFStatsType.EXPERIMENTER) {
            try {
                OFCalientPortDescStatsReply descReply = (OFCalientPortDescStatsReply)stats;
                this.opticalPorts.addAll(descReply.getPortDesc());
                this.driverHandshakeComplete.set(true);
            }
            catch (ClassCastException e) {
                this.log.error("OPLK Switch: Unexspected Experimenter Multipart message type {} ", (Object)stats.getClass().getName());
            }
        }
    }

    private static enum SubType {
        PORT_DESC_STATS,
        FLOW_STATS,
        PORT_STATS;

    }
}

