/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.driver.optical.handshaker.OplinkHandshakerUtil;
import org.onosproject.net.Device;
import org.onosproject.net.device.PortDescription;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsReply;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsRequest;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPowerReply;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;

public class OplinkRoadmHandshaker
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private List<OFPortOptical> opticalPorts = new ArrayList<OFPortOptical>();
    private OplinkHandshakerUtil oplinkUtil = new OplinkHandshakerUtil((OpenFlowSwitchDriver)this);

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        if (type == PortDescPropertyType.OPTICAL_TRANSPORT) {
            return ImmutableList.copyOf(this.opticalPorts);
        }
        this.log.warn("Unexpected port description property type: {}", (Object)type);
        return ImmutableList.of();
    }

    public List<OFPortDesc> getPorts() {
        return ImmutableList.of();
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        this.log.info("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("OPLK ROADM exception while sending experimenter port desc:", (Throwable)e);
        }
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                this.log.debug("OPLK ROADM Received barrier response");
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                this.processOFPortStatus((OFCircuitPortStatus)m);
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                OFStatsReply stats = (OFStatsReply)m;
                if (stats.getStatsType() != OFStatsType.EXPERIMENTER) break;
                this.log.debug("OPLK ROADM : Received multipart (port desc) reply message {}", (Object)m);
                this.createOpticalPortList((OFCircuitPortsReply)m);
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    public Device.Type deviceType() {
        return Device.Type.ROADM;
    }

    public final void sendMsg(OFMessage m) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(m);
        if (m.getType() == OFType.STATS_REQUEST) {
            OFStatsRequest sr = (OFStatsRequest)m;
            this.log.debug("OPLK ROADM rebuilding stats request type {}", (Object)sr.getStatsType());
            switch (sr.getStatsType()) {
                case PORT: {
                    messages.add(this.oplinkUtil.buildPortPowerRequest());
                    messages.add(this.oplinkUtil.buildPortAdjacencyRequest());
                    break;
                }
            }
        } else {
            this.log.debug("OPLK ROADM sends msg:{}, as is", (Object)m.getType());
        }
        super.sendMsg(messages);
    }

    public List<PortDescription> processExpPortStats(OFMessage msg) {
        if (msg instanceof OFOplinkPortPowerReply) {
            return this.oplinkUtil.buildPortPowerDescriptions(((OFOplinkPortPowerReply)msg).getEntries());
        }
        if (msg instanceof OFExpPortAdjacencyReply) {
            return this.oplinkUtil.buildPortAdjacencyDescriptions(((OFExpPortAdjacencyReply)msg).getEntries());
        }
        return Collections.emptyList();
    }

    private void processOFPortStatus(OFCircuitPortStatus ps) {
        this.log.debug("OPLK ROADM ..OF Port Status :", (Object)ps);
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCircuitPortsRequest circuitPortsRequest = this.oplinkUtil.buildCircuitPortsRequest();
        this.log.debug("OPLK ROADM : Sending experimented port description message {}", (Object)circuitPortsRequest);
        this.sendHandshakeMessage((OFMessage)circuitPortsRequest);
    }

    private void createOpticalPortList(OFCircuitPortsReply wPorts) {
        this.opticalPorts.addAll(wPorts.getEntries());
    }
}

