/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.onosproject.drivers.optical.OpticalAdjacencyLinkService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkService;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsRequest;
import org.projectfloodlight.openflow.protocol.OFExpPortAdidOtn;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacency;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyId;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyRequest;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPower;
import org.projectfloodlight.openflow.protocol.OFOplinkPortPowerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkHandshakerUtil {
    private OpenFlowSwitchDriver driver;
    private static final int OPSPEC_BYTES = 32;
    private static final int OPSPEC_ID_BITS = 4;
    private static final int OPSPEC_MAC_POS = 18;
    private static final int OPSPEC_MAC_BIT_OFF = 16;
    private static final int OPSPEC_PORT_POS = 24;
    private static final int OPSPEC_PORT_BIT_OFF = 32;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public OplinkHandshakerUtil(OpenFlowSwitchDriver driver) {
        this.driver = driver;
    }

    public OFOplinkPortPowerRequest buildPortPowerRequest() {
        OFOplinkPortPowerRequest request = this.driver.factory().buildOplinkPortPowerRequest().setXid((long)this.driver.getNextTransactionId()).build();
        return request;
    }

    public OFExpPortAdjacencyRequest buildPortAdjacencyRequest() {
        OFExpPortAdjacencyRequest request = this.driver.factory().buildExpPortAdjacencyRequest().setXid((long)this.driver.getNextTransactionId()).build();
        return request;
    }

    public OFCircuitPortsRequest buildCircuitPortsRequest() {
        OFCircuitPortsRequest request = this.driver.factory().buildCircuitPortsRequest().setXid((long)this.driver.getNextTransactionId()).build();
        return request;
    }

    public List<PortDescription> buildPortPowerDescriptions(List<OFOplinkPortPower> portPowers) {
        DeviceService deviceService = (DeviceService)this.driver.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.driver.data().deviceId());
        HashMap powerMap = new HashMap(portPowers.size());
        portPowers.forEach(power -> powerMap.put(Long.valueOf(power.getPort()), power));
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (Port port : ports) {
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            builder.putAll(port.annotations());
            OFOplinkPortPower power2 = (OFOplinkPortPower)powerMap.get(port.number().toLong());
            if (power2 != null) {
                builder.set("currentPower", Short.toString((short)power2.getPowerValue()));
            }
            portDescs.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{builder.build()}));
        }
        return portDescs;
    }

    public List<PortDescription> buildPortAdjacencyDescriptions(List<OFExpPortAdjacency> portAds) {
        DeviceService deviceService = (DeviceService)this.driver.handler().get(DeviceService.class);
        List ports = deviceService.getPorts(this.driver.data().deviceId());
        HashMap adMap = new HashMap(portAds.size());
        portAds.forEach(ad -> adMap.put(Long.valueOf(ad.getPortNo().getPortNumber()), ad));
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>();
        for (Port port : ports) {
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            Annotations oldAnnotations = port.annotations();
            builder.putAll(oldAnnotations);
            OFExpPortAdjacency ad2 = (OFExpPortAdjacency)adMap.get(port.number().toLong());
            OplinkPortAdjacency neighbor = this.getNeighbor(ad2);
            if (!this.linkValidation(deviceService, neighbor)) {
                builder.remove("neighborDeviceId");
                builder.remove("neighborPort");
                this.removeLink(port.number());
            } else {
                String newId = neighbor.getDeviceId().toString();
                String newPort = neighbor.getPort().toString();
                if (!newId.equals(oldAnnotations.value("neighborDeviceId")) || !newPort.equals(oldAnnotations.value("neighborPort"))) {
                    builder.set("neighborDeviceId", newId);
                    builder.set("neighborPort", newPort);
                }
                this.addLink(port.number(), neighbor);
            }
            portDescs.add((PortDescription)new DefaultPortDescription(port.number(), port.isEnabled(), port.type(), port.portSpeed(), new SparseAnnotations[]{builder.build()}));
        }
        return portDescs;
    }

    private OplinkPortAdjacency getNeighbor(OFExpPortAdjacency ad) {
        if (ad == null) {
            return null;
        }
        for (OFExpPortAdjacencyId adid : ad.getProperties()) {
            List otns = adid.getAdId();
            if (otns == null || otns.size() <= 0) continue;
            OFExpPortAdidOtn otn = (OFExpPortAdidOtn)otns.get(0);
            ChannelBuffer buffer = ChannelBuffers.buffer((int)32);
            otn.getOpspec().write32Bytes(buffer);
            long mac = buffer.getLong(18) << 4 >>> 16;
            int port = (int)(buffer.getLong(24) << 4 >>> 32);
            return new OplinkPortAdjacency(DeviceId.deviceId((URI)Dpid.uri((Dpid)new Dpid(mac))), PortNumber.portNumber((long)port));
        }
        return null;
    }

    private boolean linkValidation(DeviceService deviceService, OplinkPortAdjacency neighbor) {
        if (neighbor == null) {
            return false;
        }
        if (!deviceService.isAvailable(neighbor.getDeviceId())) {
            this.log.debug("Invalid adjacency device. devId = {}", (Object)neighbor.getDeviceId());
            return false;
        }
        if (deviceService.getPort(neighbor.getDeviceId(), neighbor.getPort()) == null) {
            this.log.debug("Invalid adjacency port. devId = {}, port = {}", (Object)neighbor.getDeviceId(), (Object)neighbor.getPort());
            return false;
        }
        return true;
    }

    private void addLink(PortNumber portNumber, OplinkPortAdjacency neighbor) {
        ConnectPoint dst = new ConnectPoint((ElementId)this.driver.handler().data().deviceId(), portNumber);
        Set links = ((LinkService)this.driver.handler().get(LinkService.class)).getIngressLinks(dst);
        for (Link link : links) {
            if (!link.src().port().equals((Object)neighbor.getPort())) continue;
            return;
        }
        OpticalAdjacencyLinkService adService = (OpticalAdjacencyLinkService)this.driver.handler().get(OpticalAdjacencyLinkService.class);
        if (!links.isEmpty()) {
            this.log.debug("Remove link of destination {}.", (Object)dst);
            adService.linksVanished(dst);
        }
        ConnectPoint src = new ConnectPoint((ElementId)neighbor.getDeviceId(), neighbor.getPort());
        this.log.debug("Add link from {} to {}.", (Object)src, (Object)dst);
        adService.linkDetected((LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.OPTICAL, new SparseAnnotations[0]));
    }

    private void removeLink(PortNumber portNumber) {
        ConnectPoint dst = new ConnectPoint((ElementId)this.driver.handler().data().deviceId(), portNumber);
        Set links = ((LinkService)this.driver.handler().get(LinkService.class)).getIngressLinks(dst);
        if (links.isEmpty()) {
            return;
        }
        this.log.debug("Remove link for {}.", (Object)dst);
        ((OpticalAdjacencyLinkService)this.driver.handler().get(OpticalAdjacencyLinkService.class)).linksVanished(dst);
    }

    private class OplinkPortAdjacency {
        private DeviceId deviceId;
        private PortNumber portNumber;

        public OplinkPortAdjacency(DeviceId deviceId, PortNumber portNumber) {
            this.deviceId = deviceId;
            this.portNumber = portNumber;
        }

        public DeviceId getDeviceId() {
            return this.deviceId;
        }

        public PortNumber getPort() {
            return this.portNumber;
        }
    }
}

