/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.handshaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.net.Device;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsReply;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsRequest;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOchSigId;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U8;

public class OfOpticalSwitchImplLinc13
extends AbstractOpenFlowSwitch
implements OpenFlowOpticalSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private long barrierXidToWaitFor = -1L;
    private List<OFPortOptical> opticalPorts;

    public void startDriverHandshake() {
        this.log.debug("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("LINC-OE exception while sending experimenter port desc:", (Throwable)e);
        }
    }

    public boolean isDriverHandshakeComplete() {
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                if (m.getXid() != this.barrierXidToWaitFor) break;
                this.log.debug("LINC-OE Received barrier response");
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                this.log.debug("****LINC-OE Port Status {} {}", (Object)this.getStringId(), (Object)m);
                this.processOFPortStatus((OFCircuitPortStatus)m);
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                OFStatsReply stats = (OFStatsReply)m;
                if (stats.getStatsType() != OFStatsType.EXPERIMENTER) break;
                this.log.debug("LINC-OE : Received stats reply message {}", (Object)m);
                this.createOpticalPortList((OFCircuitPortsReply)m);
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    public void processOFPortStatus(OFCircuitPortStatus ps) {
        this.log.debug("LINC-OE ..OF Port Status :", (Object)ps);
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCircuitPortsRequest circuitPortsRequest = this.factory().buildCircuitPortsRequest().setXid((long)this.getNextTransactionId()).build();
        this.log.debug("LINC-OE : Sending experimented circuit port stats message {}", (Object)circuitPortsRequest.toString());
        this.sendHandshakeMessage((OFMessage)circuitPortsRequest);
    }

    public List<OFPortDesc> getPorts() {
        return ImmutableList.of();
    }

    private Match rewriteMatch(Match match) {
        Match.Builder mBuilder = this.factory().buildMatch();
        for (MatchField mf : match.getMatchFields()) {
            if (mf == MatchField.EXP_OCH_SIG_ID) {
                mBuilder.setExact(MatchField.OCH_SIGID, (OFValueType)((CircuitSignalID)match.get(mf)));
                continue;
            }
            if (mf == MatchField.EXP_OCH_SIGTYPE) {
                mBuilder.setExact(MatchField.OCH_SIGTYPE, (OFValueType)((U8)match.get(mf)));
                continue;
            }
            mBuilder.setExact(mf, match.get(mf));
        }
        return mBuilder.build();
    }

    private List<OFAction> rewriteActions(List<OFAction> actions) {
        LinkedList<OFAction> newActions = new LinkedList<OFAction>();
        for (OFAction action : actions) {
            if (!(action instanceof OFActionSetField)) {
                newActions.add(action);
                continue;
            }
            OFActionSetField sf = (OFActionSetField)action;
            if (!(sf.getField() instanceof OFOxmExpOchSigId)) {
                newActions.add(action);
                continue;
            }
            OFOxmExpOchSigId oxm = (OFOxmExpOchSigId)sf.getField();
            CircuitSignalID signalId = oxm.getValue();
            newActions.add((OFAction)this.factory().actions().circuit((OFOxm)this.factory().oxms().ochSigid(signalId)));
        }
        return newActions;
    }

    public void sendMsg(OFMessage msg) {
        if (!(msg instanceof OFFlowMod) && !(msg instanceof OFFlowStatsRequest)) {
            super.sendMsg(msg);
            return;
        }
        OFFlowStatsRequest newMsg = null;
        if (msg instanceof OFFlowStatsRequest) {
            OFFlowStatsRequest fsr = (OFFlowStatsRequest)msg;
            Match newMatch = this.rewriteMatch(fsr.getMatch());
            newMsg = fsr.createBuilder().setMatch(newMatch).build();
        } else if (msg instanceof OFFlowMod) {
            OFFlowMod fm = (OFFlowMod)msg;
            Match newMatch = this.rewriteMatch(fm.getMatch());
            List<OFAction> actions = this.rewriteActions(fm.getActions());
            newMsg = fm.createBuilder().setMatch(newMatch).setActions(actions).build();
        }
        super.sendMsg(newMsg);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public Device.Type deviceType() {
        return Device.Type.ROADM;
    }

    private boolean isOChPort(long port) {
        for (OFPortDescStatsReply reply : this.ports) {
            for (OFPortDesc p : reply.getEntries()) {
                if ((long)p.getPortNo().getPortNumber() != port) continue;
                return true;
            }
        }
        return false;
    }

    private OFPortOptical createOpticalPort(OFPortOptical port, short type) {
        ArrayList<OFPortDescPropOpticalTransport> descList = new ArrayList<OFPortDescPropOpticalTransport>(port.getDesc().size());
        for (OFPortDescPropOpticalTransport desc : port.getDesc()) {
            OFPortDescPropOpticalTransport newDesc = desc.createBuilder().setType(desc.getType()).setPortSignalType(type).setPortType(desc.getPortType()).setReserved(desc.getReserved()).build();
            descList.add(newDesc);
        }
        OFPortOptical newPort = port.createBuilder().setConfig(port.getConfig()).setDesc(descList).setHwAddr(port.getHwAddr()).setName(port.getName()).setPortNo(port.getPortNo()).setState(port.getState()).build();
        return newPort;
    }

    private void createOpticalPortList(OFCircuitPortsReply wPorts) {
        this.opticalPorts = new ArrayList<OFPortOptical>(wPorts.getEntries().size());
        for (OFPortOptical p : wPorts.getEntries()) {
            short signalType = this.isOChPort(p.getPortNo().getPortNumber()) ? (short)5 : 2;
            this.opticalPorts.add(this.createOpticalPort(p, signalType));
        }
    }

    public List<? extends OFObject> getPortsOf(PortDescPropertyType type) {
        if (!type.equals((Object)PortDescPropertyType.OPTICAL_TRANSPORT)) {
            return ImmutableList.of();
        }
        return this.opticalPorts;
    }

    public Set<PortDescPropertyType> getPortTypes() {
        return ImmutableSet.of((Object)PortDescPropertyType.OPTICAL_TRANSPORT);
    }
}

