/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.flowrule;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.onosproject.driver.optical.flowrule.CrossConnect;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OchSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;

public class CrossConnectFlowRule
extends DefaultFlowRule
implements CrossConnect {
    private PortNumber addDrop;
    private OchSignal ochSignal;
    private boolean isAddRule;

    public CrossConnectFlowRule(FlowRule rule, List<PortNumber> linePorts) {
        super(rule);
        Set criteria = rule.selector().criteria();
        List instructions = rule.treatment().immediate();
        Preconditions.checkArgument((criteria.size() == 3 ? 1 : 0) != 0, (Object)"Wrong size of flow rule criteria for cross connect.");
        Preconditions.checkArgument((instructions.size() == 1 ? 1 : 0) != 0, (Object)"Wrong size of flow rule instructions for cross connect.");
        criteria.forEach(c -> Preconditions.checkArgument((c instanceof OchSignalCriterion || c instanceof OchSignalTypeCriterion || c instanceof PortCriterion ? 1 : 0) != 0, (Object)("Incompatible flow rule criteria for cross connect: " + criteria)));
        Preconditions.checkArgument((((Instruction)instructions.get(0)).type() == Instruction.Type.OUTPUT ? 1 : 0) != 0, (Object)("Incompatible flow rule instructions for cross connect: " + instructions));
        this.ochSignal = criteria.stream().filter(c -> c instanceof OchSignalCriterion).map(c -> ((OchSignalCriterion)c).lambda()).findAny().orElse(null);
        Instructions.OutputInstruction outInstruction = (Instructions.OutputInstruction)instructions.get(0);
        if (linePorts.contains(outInstruction.port())) {
            this.addDrop = criteria.stream().filter(c -> c instanceof PortCriterion).map(c -> ((PortCriterion)c).port()).findAny().orElse(null);
            this.isAddRule = true;
        } else {
            this.addDrop = outInstruction.port();
            this.isAddRule = false;
        }
    }

    @Override
    public PortNumber addDrop() {
        return this.addDrop;
    }

    @Override
    public OchSignal ochSignal() {
        return this.ochSignal;
    }

    @Override
    public boolean isAddRule() {
        return this.isAddRule;
    }
}

