/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import java.util.Optional;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.GridType;
import org.onosproject.net.config.BaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class LambdaConfig
extends BaseConfig<ConnectPoint> {
    private static final Logger log = LoggerFactory.getLogger(LambdaConfig.class);
    public static final String CONFIG_KEY = "lambdas";
    private static final String GRID_TYPE = "gridType";
    private static final String DWDM_SPACING = "dwdmSpacing";
    private static final String SLOT_START = "slotStart";
    private static final String SLOT_STEP = "slotStep";
    private static final String SLOT_END = "slotEnd";

    public boolean isValid() {
        if (!this.hasField(GRID_TYPE)) {
            log.warn("GridType missing: {}", (Object)this);
            return false;
        }
        try {
            GridType type = this.gridType();
            Optional<ChannelSpacing> dwdmSpacing = this.dwdmSpacing();
            if (type == GridType.DWDM && !dwdmSpacing.isPresent()) {
                log.warn("DWDM spacing missing: {}", (Object)this);
                return false;
            }
            return this.slotStep() > 0 && this.slotStart() <= this.slotEnd();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("Invalid netcfg: {}", (Object)this, (Object)e);
            return false;
        }
    }

    public GridType gridType() {
        return GridType.valueOf((String)this.get(GRID_TYPE, null));
    }

    public Optional<ChannelSpacing> dwdmSpacing() {
        return Optional.ofNullable(this.get(DWDM_SPACING, null)).map(ChannelSpacing::valueOf);
    }

    public int slotStart() {
        return this.get(SLOT_START, 1);
    }

    public int slotStep() {
        return this.get(SLOT_STEP, 1);
    }

    public int slotEnd() {
        return this.get(SLOT_END, 1);
    }

    public LambdaConfig() {
    }

    public LambdaConfig(ConnectPoint cp) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(cp, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }
}

