/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.BaseConfig;
import org.onosproject.net.flow.FlowRule;

public class FlowTableConfig
extends BaseConfig<DeviceId> {
    public static final String CONFIG_KEY = "flowtable";
    public static final String ENTRIES = "entries";

    public boolean isValid() {
        return this.hasField(ENTRIES);
    }

    public Set<FlowRule> flowtable() {
        JsonNode ents = this.object.path(ENTRIES);
        if (!ents.isArray()) {
            return ImmutableSet.of();
        }
        ArrayNode entries = (ArrayNode)ents;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        entries.forEach(entry -> builder.add(this.decode((JsonNode)entry, FlowRule.class)));
        return builder.build();
    }

    public FlowTableConfig flowtable(Set<FlowRule> table) {
        JsonCodec codec = this.codec(FlowRule.class);
        ArrayNode entries = codec.encode(table, (CodecContext)this);
        this.object.set(ENTRIES, (JsonNode)entries);
        return this;
    }

    public FlowTableConfig() {
    }

    public FlowTableConfig(DeviceId did) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(did, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }
}

