/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.config;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.ChassisId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.config.inject.DeviceInjectionConfig;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.config.OpticalPortConfig;

@Beta
public class ConfigOpticalDeviceDiscovery
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    public DeviceDescription discoverDeviceDetails() {
        NetworkConfigService netcfg = (NetworkConfigService)this.handler().get(NetworkConfigService.class);
        DeviceId did = this.data().deviceId();
        String unk = "UNKNOWN";
        Optional<Config> inject = Optional.ofNullable(netcfg.getConfig((Object)did, DeviceInjectionConfig.class));
        Optional<Config> basic = Optional.ofNullable(netcfg.getConfig((Object)did, BasicDeviceConfig.class));
        Device.Type type = basic.map(BasicDeviceConfig::type).orElse(Device.Type.SWITCH);
        String manufacturer = basic.map(BasicDeviceConfig::manufacturer).orElse(unk);
        String hwVersion = basic.map(BasicDeviceConfig::hwVersion).orElse(unk);
        String swVersion = basic.map(BasicDeviceConfig::swVersion).orElse(unk);
        String serialNumber = basic.map(BasicDeviceConfig::serial).orElse(unk);
        ChassisId chassis = new ChassisId();
        boolean defaultAvailable = inject.isPresent();
        return new DefaultDeviceDescription(did.uri(), type, manufacturer, hwVersion, swVersion, serialNumber, chassis, defaultAvailable, new SparseAnnotations[0]);
    }

    public List<PortDescription> discoverPortDetails() {
        DeviceId did;
        NetworkConfigService netcfg = (NetworkConfigService)this.handler().get(NetworkConfigService.class);
        DeviceInjectionConfig cfg = (DeviceInjectionConfig)netcfg.getConfig((Object)(did = this.data().deviceId()), DeviceInjectionConfig.class);
        if (cfg == null) {
            return ImmutableList.of();
        }
        String ports = cfg.ports();
        int numPorts = Integer.parseInt(ports);
        ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>(numPorts);
        for (int i = 1; i <= numPorts; ++i) {
            PortNumber number = PortNumber.portNumber((long)i);
            ConnectPoint cp = new ConnectPoint((ElementId)did, number);
            Optional<Config> port = Optional.ofNullable(netcfg.getConfig((Object)cp, OpticalPortConfig.class));
            boolean isEnabled = true;
            int speedFallback = 10000;
            long portSpeed = port.flatMap(OpticalPortConfig::speed).orElse(speedFallback).intValue();
            Port.Type type = port.map(OpticalPortConfig::type).orElse(Port.Type.COPPER);
            portDescs.add((PortDescription)new DefaultPortDescription(number, isEnabled, type, portSpeed, new SparseAnnotations[0]));
        }
        return portDescs;
    }
}

