/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.optical.config;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.driver.optical.config.FlowTableConfig;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ConfigFlowRuleProgrammable
extends AbstractHandlerBehaviour
implements FlowRuleProgrammable {
    private static final Logger log = LoggerFactory.getLogger(ConfigFlowRuleProgrammable.class);

    public Collection<FlowEntry> getFlowEntries() {
        Set<FlowRule> flowtable = this.getFlowTable(this.getFlowTableConfig());
        return flowtable.stream().map(fr -> new DefaultFlowEntry(fr, FlowEntry.FlowEntryState.ADDED)).collect(Collectors.toList());
    }

    public Collection<FlowRule> applyFlowRules(Collection<FlowRule> rules) {
        log.trace("applyFlowRules: {}", rules);
        Optional<FlowTableConfig> config = this.createFlowTableConfig();
        LinkedHashSet<FlowRule> table = new LinkedHashSet<FlowRule>(this.getFlowTable(config));
        table.addAll(rules);
        config.map(cfg -> cfg.flowtable(table)).ifPresent(cfg -> cfg.apply());
        log.trace("Updated flowtable: {}", table);
        return table;
    }

    public Collection<FlowRule> removeFlowRules(Collection<FlowRule> rules) {
        log.trace("removeFlowRules: {}", rules);
        Optional<FlowTableConfig> config = this.getFlowTableConfig();
        LinkedHashSet<FlowRule> table = new LinkedHashSet<FlowRule>(this.getFlowTable(config));
        table.removeAll(rules);
        config.map(cfg -> cfg.flowtable(table)).ifPresent(cfg -> cfg.apply());
        log.trace("Updated flowtable: {}", table);
        return table;
    }

    private Set<FlowRule> getFlowTable(Optional<FlowTableConfig> cfg) {
        Set flowtable = cfg.map(FlowTableConfig::flowtable).orElse((Set)ImmutableSet.of());
        return flowtable;
    }

    private Optional<FlowTableConfig> createFlowTableConfig() {
        NetworkConfigService netcfg = (NetworkConfigService)this.handler().get(NetworkConfigService.class);
        DeviceId did = this.data().deviceId();
        return Optional.ofNullable(netcfg.addConfig((Object)did, FlowTableConfig.class));
    }

    private Optional<FlowTableConfig> getFlowTableConfig() {
        NetworkConfigService netcfg = (NetworkConfigService)this.handler().get(NetworkConfigService.class);
        DeviceId did = this.data().deviceId();
        return Optional.ofNullable(netcfg.getConfig((Object)did, FlowTableConfig.class));
    }
}

