/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.provider.nil.NullProviders;

@Command(scope="onos", name="null-link", description="Severs or repairs a simulated link")
public class NullLinkCommand
extends AbstractShellCommand {
    @Argument(index=0, name="one", description="One link end-point as device/port", required=true, multiValued=false)
    String one = null;
    @Argument(index=1, name="two", description="Another link end-point as device/port", required=true, multiValued=false)
    String two = null;
    @Argument(index=2, name="cmd", description="up/down", required=true, multiValued=false)
    String cmd = null;

    protected void execute() {
        NullProviders service = (NullProviders)NullLinkCommand.get(NullProviders.class);
        try {
            ConnectPoint onePoint = ConnectPoint.deviceConnectPoint((String)this.one);
            ConnectPoint twoPoint = ConnectPoint.deviceConnectPoint((String)this.two);
            if (this.cmd.equals("up")) {
                service.repairLink(onePoint, twoPoint);
            } else if (this.cmd.equals("down")) {
                service.severLink(onePoint, twoPoint);
            } else {
                this.error("Illegal command %s; must be up or down", new Object[]{this.cmd});
            }
        }
        catch (NumberFormatException e) {
            this.error("Invalid port number specified", new Object[]{e});
        }
    }
}

