/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil.cli;

import java.util.Objects;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.host.HostService;
import org.onosproject.provider.nil.CustomTopologySimulator;
import org.onosproject.provider.nil.NullProviders;
import org.onosproject.provider.nil.TopologySimulator;

@Command(scope="onos", name="null-create-link", description="Adds a simulated link to the custom topology simulation")
public class CreateNullLink
extends AbstractShellCommand {
    @Argument(index=0, name="type", description="Link type, e.g. direct, indirect, optical", required=true, multiValued=false)
    String type = null;
    @Argument(index=1, name="src", description="Source device name", required=true, multiValued=false)
    String src = null;
    @Argument(index=2, name="dst", description="Destination device name", required=true, multiValued=false)
    String dst = null;
    @Option(name="-u", aliases={"--unidirectional"}, description="Unidirectional link only", required=false, multiValued=false)
    private boolean unidirectional = false;

    protected void execute() {
        NullProviders service = (NullProviders)CreateNullLink.get(NullProviders.class);
        TopologySimulator simulator = service.currentSimulator();
        if (!(simulator instanceof CustomTopologySimulator)) {
            this.error("Custom topology simulator is not active.", new Object[0]);
            return;
        }
        CustomTopologySimulator sim = (CustomTopologySimulator)simulator;
        ConnectPoint one = this.findAvailablePort(sim.deviceId(this.src), null);
        ConnectPoint two = this.findAvailablePort(sim.deviceId(this.dst), one);
        sim.createLink(one, two, Link.Type.valueOf((String)this.type.toUpperCase()), !this.unidirectional);
    }

    private ConnectPoint findAvailablePort(DeviceId deviceId, ConnectPoint otherPoint) {
        EdgePortService eps = (EdgePortService)CreateNullLink.get(EdgePortService.class);
        HostService hs = (HostService)CreateNullLink.get(HostService.class);
        for (ConnectPoint point : eps.getEdgePoints(deviceId)) {
            if (Objects.equals(point, otherPoint) || !hs.getConnectedHosts(point).isEmpty()) continue;
            return point;
        }
        return null;
    }
}

