/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.nil.TopologySimulator;

public class TreeTopologySimulator
extends TopologySimulator {
    private int[] tierMultiplier;
    private int[] tierDeviceCount;
    private int[] tierOffset;

    @Override
    protected void processTopoShape(String shape) {
        super.processTopoShape(shape);
        this.tierOffset = new int[this.topoShape.length];
        this.tierMultiplier = new int[this.topoShape.length];
        this.tierDeviceCount = new int[this.topoShape.length];
        this.deviceCount = 1;
        this.tierOffset[0] = 0;
        this.tierMultiplier[0] = 1;
        this.tierDeviceCount[0] = this.deviceCount;
        for (int i = 1; i < this.topoShape.length; ++i) {
            this.tierOffset[i] = this.deviceCount;
            this.tierMultiplier[i] = Integer.parseInt(this.topoShape[i]);
            this.tierDeviceCount[i] = this.tierDeviceCount[i - 1] * this.tierMultiplier[i];
            this.deviceCount += this.tierDeviceCount[i];
        }
    }

    @Override
    public void setUpTopology() {
        Preconditions.checkArgument((this.tierDeviceCount.length > 0 ? 1 : 0) != 0, (Object)"There must be at least one tree tier");
        super.setUpTopology();
    }

    @Override
    protected void createLinks() {
        int portOffset = 1;
        for (int t = 1; t < this.tierOffset.length; ++t) {
            int child = this.tierOffset[t];
            for (int parent = this.tierOffset[t - 1]; parent < this.tierOffset[t]; ++parent) {
                for (int i = 0; i < this.tierMultiplier[t]; ++i) {
                    this.createLink(parent, child, i + portOffset, 1);
                    ++child;
                }
            }
            portOffset = 2;
        }
    }

    @Override
    protected void createHosts() {
        for (int i = this.tierOffset[this.tierOffset.length - 1]; i < this.deviceCount; ++i) {
            this.createHosts((DeviceId)this.deviceIds.get(i), 2);
        }
    }
}

