/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopologySimulator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String[] topoShape;
    protected int deviceCount;
    protected int hostCount;
    protected ServiceDirectory directory;
    protected NodeId localNode;
    protected ClusterService clusterService;
    protected MastershipService mastershipService;
    protected DeviceAdminService deviceService;
    protected HostService hostService;
    protected LinkService linkService;
    protected DeviceProviderService deviceProviderService;
    protected HostProviderService hostProviderService;
    protected LinkProviderService linkProviderService;
    protected int maxWaitSeconds = 1;
    protected int infrastructurePorts = 2;
    protected CountDownLatch deviceLatch;
    protected final List<DeviceId> deviceIds = Lists.newArrayList();
    private DeviceListener deviceEventCounter = new DeviceEventCounter();

    protected void init(String topoShape, int deviceCount, int hostCount, ServiceDirectory directory, DeviceProviderService deviceProviderService, HostProviderService hostProviderService, LinkProviderService linkProviderService) {
        this.deviceCount = deviceCount;
        this.hostCount = hostCount;
        this.directory = directory;
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.deviceService = (DeviceAdminService)directory.get(DeviceAdminService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.deviceProviderService = deviceProviderService;
        this.hostProviderService = hostProviderService;
        this.linkProviderService = linkProviderService;
        this.localNode = this.clusterService.getLocalNode().id();
        this.processTopoShape(topoShape);
    }

    protected void processTopoShape(String shape) {
        this.topoShape = shape.split(",");
    }

    public void setUpTopology() {
        this.prepareForDeviceEvents(this.deviceCount);
        this.createDevices();
        this.waitForDeviceEvents();
        this.createLinks();
        this.createHosts();
    }

    protected void createDevices() {
        for (int i = 0; i < this.deviceCount; ++i) {
            this.createDevice(i + 1);
        }
    }

    protected abstract void createLinks();

    protected abstract void createHosts();

    protected void createDevice(int i) {
        DeviceId id = DeviceId.deviceId((String)("null:" + Tools.toHex((long)i)));
        this.deviceIds.add(id);
        this.createDevice(id, i);
    }

    public void createDevice(DeviceId id, int chassisId) {
        this.createDevice(id, chassisId, Device.Type.SWITCH, this.hostCount + this.infrastructurePorts);
    }

    public void createDevice(DeviceId id, int chassisId, Device.Type type, int portCount) {
        DefaultDeviceDescription desc = new DefaultDeviceDescription(id.uri(), type, "ON.Lab", "0.1", "0.1", "1234", new ChassisId((long)chassisId), new SparseAnnotations[0]);
        this.deviceProviderService.deviceConnected(id, (DeviceDescription)desc);
        this.deviceProviderService.updatePorts(id, this.buildPorts(portCount));
    }

    public void createLink(int i, int j, int pi, int pj) {
        ConnectPoint one = new ConnectPoint((ElementId)this.deviceIds.get(i), PortNumber.portNumber((long)pi));
        ConnectPoint two = new ConnectPoint((ElementId)this.deviceIds.get(j), PortNumber.portNumber((long)pj));
        this.createLink(one, two);
    }

    public void createLink(ConnectPoint one, ConnectPoint two) {
        this.createLink(one, two, Link.Type.DIRECT, true);
    }

    public void createLink(ConnectPoint one, ConnectPoint two, Link.Type type, boolean isBidirectional) {
        this.linkProviderService.linkDetected((LinkDescription)new DefaultLinkDescription(one, two, type, new SparseAnnotations[0]));
        if (isBidirectional) {
            this.linkProviderService.linkDetected((LinkDescription)new DefaultLinkDescription(two, one, type, new SparseAnnotations[0]));
        }
    }

    public void createHosts(DeviceId deviceId, int portOffset) {
        String s = deviceId.toString();
        byte dByte = Byte.parseByte(s.substring(s.length() - 2), 16);
        byte[] macBytes = new byte[]{0, 0, 0, 0, dByte, 0};
        byte[] ipBytes = new byte[]{-64, -88, dByte, 0};
        for (int i = 0; i < this.hostCount; ++i) {
            int port = portOffset + i + 1;
            macBytes[5] = (byte)(i + 1);
            ipBytes[3] = (byte)(i + 1);
            HostId id = HostId.hostId((MacAddress)MacAddress.valueOf((byte[])macBytes), (VlanId)VlanId.NONE);
            IpAddress ip = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])ipBytes);
            this.hostProviderService.hostDetected(id, TopologySimulator.description(id, ip, deviceId, port), false);
        }
    }

    protected void prepareForDeviceEvents(int count) {
        this.deviceLatch = new CountDownLatch(count);
        this.deviceService.addListener((EventListener)this.deviceEventCounter);
    }

    protected void waitForDeviceEvents() {
        try {
            this.deviceLatch.await(this.maxWaitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Device events did not arrive in time");
        }
        this.deviceService.removeListener((EventListener)this.deviceEventCounter);
    }

    public void tearDownTopology() {
        this.removeHosts();
        this.removeLinks();
        this.removeDevices();
    }

    protected void removeHosts() {
        this.hostService.getHosts().forEach(host -> this.hostProviderService.hostVanished(host.id()));
    }

    protected void removeLinks() {
        this.linkService.getLinks().forEach(link -> this.linkProviderService.linkVanished((LinkDescription)TopologySimulator.description(link)));
    }

    protected void removeDevices() {
        this.prepareForDeviceEvents(this.deviceIds.size());
        this.deviceIds.forEach(arg_0 -> ((DeviceProviderService)this.deviceProviderService).deviceDisconnected(arg_0));
        this.waitForDeviceEvents();
        this.deviceIds.clear();
    }

    static DeviceDescription description(Device device) {
        return new DefaultDeviceDescription(device.id().uri(), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), device.chassisId(), new SparseAnnotations[0]);
    }

    static DefaultLinkDescription description(Link link) {
        return new DefaultLinkDescription(link.src(), link.dst(), link.type(), new SparseAnnotations[0]);
    }

    static DefaultHostDescription description(Host host) {
        return new DefaultHostDescription(host.mac(), host.vlan(), host.location(), host.ipAddresses(), new SparseAnnotations[0]);
    }

    static HostDescription description(HostId hostId, IpAddress ip, DeviceId deviceId, int port) {
        HostLocation location = new HostLocation(deviceId, PortNumber.portNumber((long)port), 0L);
        return new DefaultHostDescription(hostId.mac(), hostId.vlanId(), location, ip, new SparseAnnotations[0]);
    }

    protected List<PortDescription> buildPorts(int portCount) {
        ArrayList ports = Lists.newArrayList();
        for (int i = 1; i <= portCount; ++i) {
            ports.add(new DefaultPortDescription(PortNumber.portNumber((long)i), true, Port.Type.COPPER, 0L, new SparseAnnotations[0]));
        }
        return ports;
    }

    public boolean contains(DeviceId deviceId) {
        return this.deviceIds.contains(deviceId);
    }

    private class DeviceEventCounter
    implements DeviceListener {
        private DeviceEventCounter() {
        }

        public void event(DeviceEvent event) {
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            if (type == DeviceEvent.Type.DEVICE_ADDED || type == DeviceEvent.Type.DEVICE_REMOVED || type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED) {
                TopologySimulator.this.deviceLatch.countDown();
            }
        }
    }
}

