/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.nil.LinearTopologySimulator;

public class RerouteTopologySimulator
extends LinearTopologySimulator {
    @Override
    protected void processTopoShape(String shape) {
        super.processTopoShape(shape);
        this.infrastructurePorts = 5;
        this.deviceCount = this.topoShape.length == 1 ? this.deviceCount : Integer.parseInt(this.topoShape[1]);
    }

    @Override
    public void setUpTopology() {
        Preconditions.checkArgument((this.deviceCount > 2 ? 1 : 0) != 0, (Object)"There must be at least 3 devices");
        super.setUpTopology();
    }

    @Override
    protected void createLinks() {
        int portOffset = 1;
        int n = this.deviceCount - 2;
        for (int i = 0; i < n; ++i) {
            this.createLink(i, i + 1, portOffset, 1);
            portOffset = 2;
        }
        int middle = (this.deviceCount - 1) / 2;
        int alternate = this.deviceCount - 1;
        this.createLink(middle - 1, alternate, 3, 1);
        this.createLink(middle, alternate, 3, 2);
    }

    @Override
    protected void createHosts() {
        this.createHosts((DeviceId)this.deviceIds.get(0), this.infrastructurePorts);
        this.createHosts((DeviceId)this.deviceIds.get(this.deviceCount - 2), this.infrastructurePorts);
    }
}

