/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.util.Timer;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleProvider;
import org.onosproject.net.flow.FlowRuleProviderService;
import org.onosproject.provider.nil.NullProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NullFlowRuleProvider
extends NullProviders.AbstractNullProvider
implements FlowRuleProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConcurrentMap<DeviceId, Set<FlowEntry>> flowTable = new ConcurrentHashMap<DeviceId, Set<FlowEntry>>();
    private FlowRuleProviderService providerService;
    private HashedWheelTimer timer = Timer.getTimer();
    private Timeout timeout;

    NullFlowRuleProvider() {
    }

    void start(FlowRuleProviderService providerService) {
        this.providerService = providerService;
        this.timeout = this.timer.newTimeout((TimerTask)new StatisticTask(), 5L, TimeUnit.SECONDS);
    }

    void stop() {
        this.timeout.cancel();
    }

    public void applyFlowRule(FlowRule ... flowRules) {
    }

    public void removeFlowRule(FlowRule ... flowRules) {
    }

    public void removeRulesById(ApplicationId id, FlowRule ... flowRules) {
        throw new UnsupportedOperationException("Cannot remove by appId from null provider");
    }

    public void executeBatch(FlowRuleBatchOperation batch) {
        Set<FlowEntry> entries = this.flowTable.getOrDefault(batch.deviceId(), Sets.newConcurrentHashSet());
        block5: for (FlowRuleBatchEntry fbe : batch.getOperations()) {
            switch ((FlowRuleBatchEntry.FlowRuleOperation)fbe.operator()) {
                case ADD: {
                    entries.add((FlowEntry)new DefaultFlowEntry((FlowRule)fbe.target()));
                    continue block5;
                }
                case REMOVE: {
                    entries.remove(new DefaultFlowEntry((FlowRule)fbe.target()));
                    continue block5;
                }
                case MODIFY: {
                    DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)fbe.target());
                    entries.remove(entry);
                    entries.add((FlowEntry)entry);
                    continue block5;
                }
            }
            this.log.error("Unknown flow operation: {}", (Object)fbe);
        }
        this.flowTable.put(batch.deviceId(), entries);
        CompletedBatchOperation op = new CompletedBatchOperation(true, Collections.emptySet(), batch.deviceId());
        this.providerService.batchOperationCompleted(batch.id(), op);
    }

    private class StatisticTask
    implements TimerTask {
        private StatisticTask() {
        }

        public void run(Timeout to) throws Exception {
            for (DeviceId devId : NullFlowRuleProvider.this.flowTable.keySet()) {
                Set entries = NullFlowRuleProvider.this.flowTable.getOrDefault(devId, Collections.emptySet());
                NullFlowRuleProvider.this.providerService.pushFlowMetrics(devId, entries);
            }
            NullFlowRuleProvider.this.timeout = NullFlowRuleProvider.this.timer.newTimeout(to.getTask(), 5L, TimeUnit.SECONDS);
        }
    }
}

