/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.nil.TopologySimulator;

public class MeshTopologySimulator
extends TopologySimulator {
    @Override
    protected void processTopoShape(String shape) {
        super.processTopoShape(shape);
        this.deviceCount = this.topoShape.length > 1 ? Integer.parseInt(this.topoShape[1]) : this.deviceCount;
        this.hostCount = this.topoShape.length > 2 ? Integer.parseInt(this.topoShape[2]) : this.hostCount;
    }

    @Override
    public void setUpTopology() {
        Preconditions.checkArgument((this.deviceCount > 1 ? 1 : 0) != 0, (Object)"There must be at least 2 devices");
        Preconditions.checkArgument((this.hostCount > 0 ? 1 : 0) != 0, (Object)"There must be at least 1 host");
        super.setUpTopology();
    }

    @Override
    protected void createLinks() {
        int n = this.deviceCount - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                this.createLink(i, i + j + 1, i + j + 1, i + 1);
            }
        }
    }

    @Override
    protected void createHosts() {
        int n = this.deviceCount;
        for (int i = 0; i < n; ++i) {
            this.createHosts((DeviceId)this.deviceIds.get(i), this.deviceCount - 1);
        }
    }
}

