/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.nil.TopologySimulator;

public class GridTopologySimulator
extends TopologySimulator {
    private int cols;
    private int rows;

    @Override
    protected void processTopoShape(String shape) {
        super.processTopoShape(shape);
        this.rows = this.topoShape.length > 1 ? Integer.parseInt(this.topoShape[1]) : 10;
        this.cols = this.topoShape.length > 2 ? Integer.parseInt(this.topoShape[2]) : this.rows;
        this.hostCount = this.topoShape.length > 3 ? Integer.parseInt(this.topoShape[3]) : 1;
        this.infrastructurePorts = 4;
        this.deviceCount = this.rows * this.cols;
    }

    @Override
    public void setUpTopology() {
        Preconditions.checkArgument((this.rows > 1 ? 1 : 0) != 0, (Object)"There must be at least 2 rows");
        Preconditions.checkArgument((this.cols > 1 ? 1 : 0) != 0, (Object)"There must be at least 2 columns");
        super.setUpTopology();
    }

    @Override
    protected void createLinks() {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                int i = r * this.cols + c;
                if (c < this.cols - 1) {
                    this.createLink(i, i + 1, 3, 1);
                }
                if (r >= this.rows - 1) continue;
                this.createLink(i, (r + 1) * this.cols + c, 4, 2);
            }
        }
    }

    @Override
    protected void createHosts() {
        this.deviceIds.forEach(id -> this.createHosts((DeviceId)id, this.infrastructurePorts));
    }
}

