/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.collect.Maps;
import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.provider.nil.TopologySimulator;

public class CustomTopologySimulator
extends TopologySimulator {
    private int nextDeviceId = 0;
    private int nextHostId = 0;
    private Map<String, DeviceId> nameToId = Maps.newConcurrentMap();

    public DeviceId nextDeviceId() {
        return DeviceId.deviceId((String)("null:" + Tools.toHex((long)(++this.nextDeviceId))));
    }

    public HostId nextHostId() {
        return HostId.hostId((MacAddress)MacAddress.valueOf((long)(++this.nextHostId)), (VlanId)VlanId.NONE);
    }

    public DeviceId deviceId(String name) {
        return this.nameToId.get(name);
    }

    public void createDevice(DeviceId id, String name, Device.Type type, int portCount) {
        int chassisId = Integer.parseInt(id.uri().getSchemeSpecificPart(), 16);
        this.createDevice(id, chassisId, type, portCount);
        this.nameToId.put(name, id);
    }

    public void createHost(HostId hostId, HostLocation location, IpAddress hostIp) {
        DefaultHostDescription description = new DefaultHostDescription(hostId.mac(), hostId.vlanId(), location, hostIp, new SparseAnnotations[0]);
        this.hostProviderService.hostDetected(hostId, (HostDescription)description, false);
    }

    @Override
    protected void createDevices() {
    }

    @Override
    protected void createLinks() {
    }

    @Override
    protected void createHosts() {
    }

    public void resetIdSeeds() {
        this.nextDeviceId = 0;
        this.nextHostId = 0;
    }
}

