/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.faultmanagement.api.AlarmStore;
import org.onosproject.faultmanagement.api.AlarmStoreDelegate;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedAlarmStore
extends AbstractStore<AlarmEvent, AlarmStoreDelegate>
implements AlarmStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ConsistentMap<AlarmId, Alarm> alarms;
    private Map<AlarmId, Alarm> alarmsMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final MapEventListener<AlarmId, Alarm> listener = new InternalListener();

    @Activate
    public void activate() {
        this.log.info("Started");
        this.alarms = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-alarm-table")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{Alarm.class, DefaultAlarm.class, AlarmId.class, AlarmEvent.Type.class, Alarm.SeverityLevel.class, AlarmEntityId.class}))).build();
        this.alarms.addListener(this.listener);
        this.alarmsMap = this.alarms.asJavaMap();
    }

    @Deactivate
    public void deactivate() {
        this.alarms.removeListener(this.listener);
        this.log.info("Stopped");
    }

    @Modified
    public boolean modified() {
        this.log.info("Modified");
        return true;
    }

    @Override
    public Alarm getAlarm(AlarmId alarmId) {
        return this.alarmsMap.get(alarmId);
    }

    @Override
    public Collection<Alarm> getAlarms() {
        return ImmutableSet.copyOf(this.alarmsMap.values());
    }

    @Override
    public Collection<Alarm> getAlarms(DeviceId deviceId) {
        return ImmutableSet.copyOf((Collection)this.alarmsMap.values().stream().filter(alarm -> alarm.deviceId().equals((Object)deviceId)).collect(Collectors.toSet()));
    }

    @Override
    public void createOrUpdateAlarm(Alarm alarm) {
        Alarm existing = this.alarmsMap.get(alarm.id());
        if (Objects.equals(existing, alarm)) {
            this.log.info("Received identical alarm, no operation needed on {}", (Object)alarm.id());
        } else {
            this.alarms.put((Object)alarm.id(), (Object)alarm);
        }
    }

    @Override
    public void removeAlarm(AlarmId alarmId) {
        this.alarms.remove((Object)alarmId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalListener
    implements MapEventListener<AlarmId, Alarm> {
        private InternalListener() {
        }

        public void event(MapEvent<AlarmId, Alarm> mapEvent) {
            Alarm alarm;
            AlarmEvent.Type type;
            switch (mapEvent.type()) {
                case INSERT: {
                    type = AlarmEvent.Type.CREATED;
                    alarm = (Alarm)mapEvent.newValue().value();
                    break;
                }
                case UPDATE: {
                    type = AlarmEvent.Type.UPDATED;
                    alarm = (Alarm)mapEvent.newValue().value();
                    break;
                }
                case REMOVE: {
                    type = AlarmEvent.Type.REMOVED;
                    alarm = (Alarm)mapEvent.oldValue().value();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong event type " + mapEvent.type());
                }
            }
            DistributedAlarmStore.this.notifyDelegate((Event)new AlarmEvent(type, alarm));
        }
    }
}

