/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.util;

import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.statistic.Load;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.topo.BiLink;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.Mod;
import org.onosproject.ui.topo.TopoUtils;

public class TrafficLink
extends BiLink {
    private static final Mod PORT_TRAFFIC_GREEN = new Mod("port-traffic-green");
    private static final Mod PORT_TRAFFIC_YELLOW = new Mod("port-traffic-yellow");
    private static final Mod PORT_TRAFFIC_ORANGE = new Mod("port-traffic-orange");
    private static final Mod PORT_TRAFFIC_RED = new Mod("port-traffic-red");
    private static final String EMPTY = "";
    private long bytes = 0L;
    private long rate = 0L;
    private long flows = 0L;
    private LinkHighlight.Flavor taggedFlavor = LinkHighlight.Flavor.NO_HIGHLIGHT;
    private boolean hasTraffic = false;
    private boolean isOptical = false;
    private boolean antMarch = false;
    private Set<Mod> mods = new HashSet();

    public TrafficLink(LinkKey key, Link link) {
        super(key, link);
    }

    public TrafficLink(UiLinkId id) {
        super(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrafficLink that = (TrafficLink)o;
        return this.bytes == that.bytes && this.rate == that.rate && this.flows == that.flows && this.hasTraffic == that.hasTraffic && this.isOptical == that.isOptical && this.antMarch == that.antMarch && this.taggedFlavor == that.taggedFlavor && this.mods.equals(that.mods);
    }

    public int hashCode() {
        int result = (int)(this.bytes ^ this.bytes >>> 32);
        result = 31 * result + (int)(this.rate ^ this.rate >>> 32);
        result = 31 * result + (int)(this.flows ^ this.flows >>> 32);
        result = 31 * result + this.taggedFlavor.hashCode();
        result = 31 * result + (this.hasTraffic ? 1 : 0);
        result = 31 * result + (this.isOptical ? 1 : 0);
        result = 31 * result + (this.antMarch ? 1 : 0);
        result = 31 * result + this.mods.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("linkId", (Object)this.linkId()).add("bytes", this.bytes).add("rate", this.rate).add("flows", this.flows).toString();
    }

    public long bytes() {
        return this.bytes;
    }

    public long rate() {
        return this.rate;
    }

    public long flows() {
        return this.flows;
    }

    public TrafficLink optical(boolean b) {
        this.isOptical = b;
        return this;
    }

    public TrafficLink antMarch(boolean b) {
        this.antMarch = b;
        return this;
    }

    public TrafficLink tagFlavor(LinkHighlight.Flavor flavor) {
        this.taggedFlavor = flavor;
        return this;
    }

    public TrafficLink tagMods(Set<Mod> mods) {
        if (mods != null) {
            this.mods.addAll(mods);
        }
        return this;
    }

    public void addLoad(Load load) {
        this.addLoad(load, 0.0);
    }

    public void addLoad(Load load, double threshold) {
        if (load != null) {
            this.hasTraffic = this.hasTraffic || (double)load.rate() > threshold;
            this.bytes += load.latest();
            this.rate += load.rate();
        }
    }

    public void addFlows(int count) {
        this.flows += (long)count;
    }

    public void mergeStats(TrafficLink other) {
        this.bytes += other.bytes;
        this.rate += other.rate;
        this.flows += other.flows;
    }

    public LinkHighlight highlight(Enum<?> type) {
        StatsType statsType = (StatsType)type;
        switch (1.$SwitchMap$org$onosproject$ui$impl$topo$util$TrafficLink$StatsType[statsType.ordinal()]) {
            case 1: {
                return this.highlightForFlowCount();
            }
            case 2: 
            case 3: 
            case 4: {
                return this.highlightForStats(statsType);
            }
            case 5: {
                return this.highlightForTagging();
            }
        }
        throw new IllegalStateException("unexpected case: " + statsType);
    }

    private LinkHighlight highlightForStats(StatsType type) {
        TopoUtils.ValueLabel vl = null;
        Mod m = null;
        switch (1.$SwitchMap$org$onosproject$ui$impl$topo$util$TrafficLink$StatsType[type.ordinal()]) {
            case 2: {
                vl = TopoUtils.formatBytes((long)this.bytes);
                break;
            }
            case 3: {
                vl = TopoUtils.formatClippedBitRate((long)this.rate);
                if (vl.magnitude() == TopoUtils.Magnitude.ONE || vl.magnitude() == TopoUtils.Magnitude.KILO) {
                    m = PORT_TRAFFIC_GREEN;
                    break;
                }
                if (vl.magnitude() == TopoUtils.Magnitude.MEGA) {
                    m = PORT_TRAFFIC_YELLOW;
                    break;
                }
                if (vl.magnitude() != TopoUtils.Magnitude.GIGA) break;
                m = vl.clipped() ? PORT_TRAFFIC_RED : PORT_TRAFFIC_ORANGE;
                break;
            }
            case 4: {
                vl = TopoUtils.formatPacketRate((long)this.rate);
                if (this.rate < 10L) {
                    m = PORT_TRAFFIC_GREEN;
                    break;
                }
                if (this.rate < 1000L) {
                    m = PORT_TRAFFIC_YELLOW;
                    break;
                }
                if (this.rate < 100000L) {
                    m = PORT_TRAFFIC_ORANGE;
                    break;
                }
                m = PORT_TRAFFIC_RED;
                break;
            }
        }
        LinkHighlight hlite = new LinkHighlight(this.linkId(), LinkHighlight.Flavor.SECONDARY_HIGHLIGHT);
        if (vl != null) {
            hlite.setLabel(vl.toString());
        }
        if (m != null) {
            hlite.addMod(m);
        }
        return this.addCustomMods(hlite);
    }

    private LinkHighlight highlightForFlowCount() {
        LinkHighlight.Flavor flavor = this.flows > 0L ? LinkHighlight.Flavor.PRIMARY_HIGHLIGHT : LinkHighlight.Flavor.SECONDARY_HIGHLIGHT;
        LinkHighlight hlite = new LinkHighlight(this.linkId(), flavor).setLabel(TopoUtils.formatFlows((long)this.flows));
        return this.addCustomMods(hlite);
    }

    private LinkHighlight highlightForTagging() {
        LinkHighlight hlite = new LinkHighlight(this.linkId(), this.taggedFlavor).setLabel(this.hasTraffic ? TopoUtils.formatBytes((long)this.bytes).toString() : EMPTY);
        if (this.isOptical) {
            hlite.addMod(LinkHighlight.MOD_OPTICAL);
        }
        if (this.antMarch) {
            hlite.addMod(LinkHighlight.MOD_ANIMATED);
        }
        return this.addCustomMods(hlite);
    }

    private LinkHighlight addCustomMods(LinkHighlight hlite) {
        if (!this.mods.isEmpty()) {
            this.mods.forEach(arg_0 -> ((LinkHighlight)hlite).addMod(arg_0));
        }
        return hlite;
    }

    public boolean hasTraffic() {
        return this.hasTraffic;
    }
}

