/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.util;

import com.google.common.base.Preconditions;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.cluster.ClusterService;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.TopologyService;

public class ServicesBundle {
    private ClusterService clusterService;
    private TopologyService topologyService;
    private DeviceService deviceService;
    private HostService hostService;
    private LinkService linkService;
    private TunnelService tunnelService;
    private MastershipService mastershipService;
    private MastershipAdminService mastershipAdminService;
    private IntentService intentService;
    private FlowRuleService flowService;
    private StatisticService flowStatsService;
    private PortStatisticsService portStatsService;

    public ServicesBundle(ServiceDirectory directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.tunnelService = (TunnelService)directory.get(TunnelService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.mastershipAdminService = (MastershipAdminService)directory.get(MastershipAdminService.class);
        this.intentService = (IntentService)directory.get(IntentService.class);
        this.flowService = (FlowRuleService)directory.get(FlowRuleService.class);
        this.flowStatsService = (StatisticService)directory.get(StatisticService.class);
        this.portStatsService = (PortStatisticsService)directory.get(PortStatisticsService.class);
    }

    public ClusterService cluster() {
        return this.clusterService;
    }

    public TopologyService topology() {
        return this.topologyService;
    }

    public DeviceService device() {
        return this.deviceService;
    }

    public HostService host() {
        return this.hostService;
    }

    public LinkService link() {
        return this.linkService;
    }

    public TunnelService tunnel() {
        return this.tunnelService;
    }

    public MastershipService mastership() {
        return this.mastershipService;
    }

    public MastershipAdminService mastershipAdmin() {
        return this.mastershipAdminService;
    }

    public IntentService intent() {
        return this.intentService;
    }

    public FlowRuleService flow() {
        return this.flowService;
    }

    public StatisticService flowStats() {
        return this.flowStatsService;
    }

    public PortStatisticsService portStats() {
        return this.portStatsService;
    }
}

