/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.net.intent.Intent;
import org.onosproject.ui.impl.topo.util.TopoIntentFilter;
import org.onosproject.ui.topo.NodeSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntentSelection {
    private static final int ALL = -1;
    protected static final Logger log = LoggerFactory.getLogger(IntentSelection.class);
    private final NodeSelection nodes;
    private final List<Intent> intents;
    private int index = -1;

    public IntentSelection(NodeSelection nodes, TopoIntentFilter filter) {
        this.nodes = nodes;
        this.intents = filter.findPathIntents(nodes.hostsWithHover(), nodes.devicesWithHover(), nodes.linksWithHover());
        if (this.intents.size() == 1) {
            this.index = 0;
        }
    }

    public IntentSelection(Intent intent) {
        this.nodes = null;
        this.intents = new ArrayList(1);
        this.intents.add(intent);
        this.index = 0;
    }

    public boolean none() {
        return this.intents.isEmpty();
    }

    public boolean all() {
        return this.index == -1;
    }

    public boolean single() {
        return !this.all();
    }

    public int size() {
        return this.intents.size();
    }

    public int index() {
        return this.index;
    }

    public List<Intent> intents() {
        return Collections.unmodifiableList(this.intents);
    }

    public Intent next() {
        ++this.index;
        if (this.index >= this.intents.size()) {
            this.index = 0;
        }
        return (Intent)this.intents.get(this.index);
    }

    public Intent prev() {
        --this.index;
        if (this.index < 0) {
            this.index = this.intents.size() - 1;
        }
        return (Intent)this.intents.get(this.index);
    }

    public Intent current() {
        return this.all() ? null : (Intent)this.intents.get(this.index);
    }

    public String toString() {
        return "IntentSelection{nodes=" + this.nodes + ", #intents=" + this.intents.size() + ", index=" + this.index + '}';
    }
}

