/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventDispatcher;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionListener;
import org.onosproject.net.region.RegionService;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.topo.Topo2Jsonifier;
import org.onosproject.ui.impl.topo.UiTopoSession;
import org.onosproject.ui.impl.topo.model.ModelCache;
import org.onosproject.ui.impl.topo.model.UiModelListener;
import org.onosproject.ui.impl.topo.model.UiSharedTopologyModel;
import org.onosproject.ui.model.ServiceBundle;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiModelEvent;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={UiSharedTopologyModel.class})
public final class UiSharedTopologyModel
extends AbstractListenerManager<UiModelEvent, UiModelListener> {
    private static final Logger log = LoggerFactory.getLogger(UiSharedTopologyModel.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private UiTopoLayoutService layoutService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private RegionService regionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private FlowRuleService flowService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private StatisticService flowStatsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private PortStatisticsService portStatsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private TunnelService tunnelService;
    private final ClusterEventListener clusterListener = new InternalClusterListener(this, null);
    private final MastershipListener mastershipListener = new InternalMastershipListener(this, null);
    private final RegionListener regionListener = new InternalRegionListener(this, null);
    private final DeviceListener deviceListener = new InternalDeviceListener(this, null);
    private final LinkListener linkListener = new InternalLinkListener(this, null);
    private final HostListener hostListener = new InternalHostListener(this, null);
    private final IntentListener intentListener = new InternalIntentListener(this, null);
    private final FlowRuleListener flowRuleListener = new InternalFlowRuleListener(this, null);
    private ExecutorService eventHandler;
    private ModelCache cache;

    @Activate
    protected void activate() {
        this.cache = new ModelCache((ServiceBundle)new DefaultServiceBundle(this, null), (EventDispatcher)this.eventDispatcher);
        this.eventHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/ui/topo", (String)"event-handler", (Logger)log));
        this.eventDispatcher.addSink(UiModelEvent.class, (EventSink)this.listenerRegistry);
        this.clusterService.addListener((EventListener)this.clusterListener);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.regionService.addListener((EventListener)this.regionListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.intentService.addListener((EventListener)this.intentListener);
        this.flowService.addListener((EventListener)this.flowRuleListener);
        this.cache.load();
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.eventDispatcher.removeSink(UiModelEvent.class);
        this.clusterService.removeListener((EventListener)this.clusterListener);
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.regionService.removeListener((EventListener)this.regionListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.intentService.removeListener((EventListener)this.intentListener);
        this.flowService.removeListener((EventListener)this.flowRuleListener);
        this.eventHandler.shutdown();
        this.cache.clear();
        this.cache = null;
        log.info("Stopped");
    }

    public void injectJsonifier(Topo2Jsonifier t2json) {
        this.cache.injectJsonifier(t2json);
    }

    public void register(UiTopoSession session) {
        log.info("Registering topology session {}", (Object)session);
        this.addListener((EventListener)session);
    }

    public void unregister(UiTopoSession session) {
        log.info("Unregistering topology session {}", (Object)session);
        this.removeListener((EventListener)session);
    }

    public void refresh() {
        this.cache.refresh();
    }

    public List<UiClusterMember> getClusterMembers() {
        return this.cache.getAllClusterMembers();
    }

    public Set<UiRegion> getRegions() {
        return this.cache.getAllRegions();
    }

    public UiRegion getRegion(RegionId id) {
        return this.cache.accessRegion(id);
    }

    public UiRegion getNullRegion() {
        return this.cache.nullRegion();
    }

    public Set<UiDevice> getDevices() {
        return this.cache.getAllDevices();
    }

    public Set<UiHost> getHosts() {
        return this.cache.getAllHosts();
    }

    public Set<UiDeviceLink> getDeviceLinks() {
        return this.cache.getAllDeviceLinks();
    }

    public List<UiSynthLink> getSynthLinks(RegionId regionId) {
        return this.cache.getSynthLinks(regionId);
    }

    public Map<UiLinkId, UiSynthLink> relevantSynthLinks(RegionId regionId) {
        return this.cache.relevantSynthLinks(regionId);
    }

    static /* synthetic */ UiTopoLayoutService access$900(UiSharedTopologyModel x0) {
        return x0.layoutService;
    }

    static /* synthetic */ ClusterService access$1000(UiSharedTopologyModel x0) {
        return x0.clusterService;
    }

    static /* synthetic */ MastershipService access$1100(UiSharedTopologyModel x0) {
        return x0.mastershipService;
    }

    static /* synthetic */ RegionService access$1200(UiSharedTopologyModel x0) {
        return x0.regionService;
    }

    static /* synthetic */ DeviceService access$1300(UiSharedTopologyModel x0) {
        return x0.deviceService;
    }

    static /* synthetic */ LinkService access$1400(UiSharedTopologyModel x0) {
        return x0.linkService;
    }

    static /* synthetic */ HostService access$1500(UiSharedTopologyModel x0) {
        return x0.hostService;
    }

    static /* synthetic */ IntentService access$1600(UiSharedTopologyModel x0) {
        return x0.intentService;
    }

    static /* synthetic */ FlowRuleService access$1700(UiSharedTopologyModel x0) {
        return x0.flowService;
    }

    static /* synthetic */ ExecutorService access$1800(UiSharedTopologyModel x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ ModelCache access$1900(UiSharedTopologyModel x0) {
        return x0.cache;
    }

    protected void bindLayoutService(UiTopoLayoutService uiTopoLayoutService) {
        this.layoutService = uiTopoLayoutService;
    }

    protected void unbindLayoutService(UiTopoLayoutService uiTopoLayoutService) {
        if (this.layoutService == uiTopoLayoutService) {
            this.layoutService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindRegionService(RegionService regionService) {
        this.regionService = regionService;
    }

    protected void unbindRegionService(RegionService regionService) {
        if (this.regionService == regionService) {
            this.regionService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindFlowService(FlowRuleService flowRuleService) {
        this.flowService = flowRuleService;
    }

    protected void unbindFlowService(FlowRuleService flowRuleService) {
        if (this.flowService == flowRuleService) {
            this.flowService = null;
        }
    }

    protected void bindFlowStatsService(StatisticService statisticService) {
        this.flowStatsService = statisticService;
    }

    protected void unbindFlowStatsService(StatisticService statisticService) {
        if (this.flowStatsService == statisticService) {
            this.flowStatsService = null;
        }
    }

    protected void bindPortStatsService(PortStatisticsService portStatisticsService) {
        this.portStatsService = portStatisticsService;
    }

    protected void unbindPortStatsService(PortStatisticsService portStatisticsService) {
        if (this.portStatsService == portStatisticsService) {
            this.portStatsService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }
}

