/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.LinkKey;
import org.onosproject.ui.impl.TrafficMonitorBase;
import org.onosproject.ui.impl.topo.Topo2TrafficMessageHandler;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.topo.Highlights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Traffic2Monitor
extends TrafficMonitorBase {
    private static final Logger log = LoggerFactory.getLogger(Traffic2Monitor.class);
    private final Topo2TrafficMessageHandler msgHandler;

    public Traffic2Monitor(long trafficPeriod, ServicesBundle servicesBundle, Topo2TrafficMessageHandler msgHandler) {
        super(trafficPeriod, servicesBundle);
        this.msgHandler = msgHandler;
    }

    protected void sendAllFlowTraffic() {
        log.debug("TOPO-2-TRAFFIC: sendAllFlowTraffic");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.FLOW_STATS));
    }

    protected void sendAllPortTrafficBits() {
        log.debug("TOPO-2-TRAFFIC: sendAllPortTrafficBits");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.PORT_STATS));
    }

    protected void sendAllPortTrafficPackets() {
        log.debug("TOPO-2-TRAFFIC: sendAllPortTrafficPackets");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.PORT_PACKET_STATS));
    }

    protected void sendClearHighlights() {
        log.debug("TOPO-2-TRAFFIC: sendClearHighlights");
        this.msgHandler.sendHighlights(new Highlights());
    }

    protected void sendDeviceLinkFlows() {
    }

    protected void sendSelectedIntentTraffic() {
    }

    protected void clearSelection() {
    }

    protected Set<TrafficLink> doAggregation(Set<TrafficLink> linksWithTraffic) {
        log.debug("Need to aggregate {} links", (Object)linksWithTraffic.size());
        Map synthLinkMap = this.msgHandler.retrieveRelevantSynthLinks();
        HashMap<UiLinkId, TrafficLink> mappedByUiLinkId = new HashMap<UiLinkId, TrafficLink>();
        for (TrafficLink tl : linksWithTraffic) {
            UiLinkId tlid = UiLinkId.uiLinkId((LinkKey)tl.key());
            UiSynthLink sl = (UiSynthLink)synthLinkMap.get(tlid);
            if (sl == null) continue;
            UiLinkId aggrid = sl.link().id();
            TrafficLink aggregated = mappedByUiLinkId.computeIfAbsent(aggrid, TrafficLink::new);
            aggregated.mergeStats(tl);
        }
        HashSet<TrafficLink> result = new HashSet<TrafficLink>();
        result.addAll(mappedByUiLinkId.values());
        return result;
    }
}

