/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.impl.UiWebSocket;
import org.onosproject.ui.impl.topo.Topo2TrafficMessageHandler;
import org.onosproject.ui.impl.topo.Traffic2Monitor;
import org.onosproject.ui.impl.topo.UiTopoSession;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.TopoJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topo2TrafficMessageHandler
extends UiMessageHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REQUEST_ALL_TRAFFIC = "topo2RequestAllTraffic";
    private static final String CANCEL_TRAFFIC = "topo2CancelTraffic";
    private static final String TRAFFIC_TYPE = "trafficType";
    private static final String FLOW_STATS_BYTES = "flowStatsBytes";
    private static final String PORT_STATS_BIT_SEC = "portStatsBitSec";
    private static final String PORT_STATS_PKT_SEC = "portStatsPktSec";
    private static final long TRAFFIC_PERIOD = 5000L;
    protected ServicesBundle services;
    private UiTopoSession topoSession;
    private Traffic2Monitor traffic;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.services = new ServicesBundle(directory);
        this.traffic = new Traffic2Monitor(5000L, this.services, this);
        this.topoSession = ((UiWebSocket)connection).topoSession();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new Topo2AllTraffic(this, null), (Object)new Topo2CancelTraffic(this, null));
    }

    void ceaseAndDesist() {
        this.traffic.stopMonitoring();
    }

    void sendHighlights(Highlights highlights) {
        this.sendMessage(TopoJson.topo2HighlightsMessage((Highlights)highlights));
    }

    Map<UiLinkId, UiSynthLink> retrieveRelevantSynthLinks() {
        return this.topoSession.relevantSynthLinks();
    }

    static /* synthetic */ Logger access$200(Topo2TrafficMessageHandler x0) {
        return x0.log;
    }

    static /* synthetic */ Traffic2Monitor access$300(Topo2TrafficMessageHandler x0) {
        return x0.traffic;
    }
}

