/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.ui.UiTopo2Overlay;
import org.onosproject.ui.impl.topo.Topo2OverlayCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topo2OverlayCache {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String EMPTY = "";
    private static final String NO_OVERLAY = "No Overlay";
    private static final String UNKNOWN = "unknown";
    private static final UiTopo2Overlay NONE = new NullOverlay();
    private final Map<String, UiTopo2Overlay> overlays = new HashMap();
    private UiTopo2Overlay current = null;

    public Topo2OverlayCache() {
        this.overlays.put(null, NONE);
    }

    public void add(UiTopo2Overlay overlay) {
        this.overlays.put(overlay.id(), overlay);
        this.log.warn("added overlay: " + overlay);
    }

    public void destroy() {
        this.overlays.clear();
    }

    public void switchOverlay(String deact, String act) {
        UiTopo2Overlay toDeactivate = this.getOverlay(deact);
        UiTopo2Overlay toActivate = this.getOverlay(act);
        toDeactivate.deactivate();
        this.current = toActivate;
        this.current.activate();
    }

    private UiTopo2Overlay getOverlay(String id) {
        return Strings.isNullOrEmpty((String)id) ? NONE : (UiTopo2Overlay)this.overlays.get(id);
    }

    public UiTopo2Overlay currentOverlay() {
        return this.current;
    }

    public int size() {
        return this.overlays.size();
    }

    public boolean isActive(String overlayId) {
        return this.currentOverlay().id().equals(overlayId);
    }

    public Collection<UiTopo2Overlay> list() {
        return this.overlays.values();
    }
}

