/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.region.Region;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiPreferencesService;
import org.onosproject.ui.UiTopoMap;
import org.onosproject.ui.UiTopoMapFactory;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiModelEvent;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.topo.LayoutLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topo2Jsonifier {
    private static final String E_DEF_NOT_LAST = "UiNode.LAYER_DEFAULT not last in layer list";
    private static final String E_UNKNOWN_UI_NODE = "Unknown subclass of UiNode: ";
    private static final String CONTEXT_KEY_DELIM = "_";
    private static final String NO_CONTEXT = "";
    private static final String ZOOM_KEY = "layoutZoom";
    private static final String REGION = "region";
    private static final String DEVICE = "device";
    private static final String HOST = "host";
    private static final String TYPE = "type";
    private static final String SUBJECT = "subject";
    private static final String DATA = "data";
    private static final String MEMO = "memo";
    private static final String GEO = "geo";
    private static final String GRID = "grid";
    private static final String PEER_LOCATIONS = "peerLocations";
    private static final String LOCATION = "location";
    private static final String LOC_TYPE = "locType";
    private static final String LAT_OR_Y = "latOrY";
    private static final String LONG_OR_X = "longOrX";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper = new ObjectMapper();
    private final String userName;
    private ServiceDirectory directory;
    private ClusterService clusterService;
    private DeviceService deviceService;
    private LinkService linkService;
    private HostService hostService;
    private MastershipService mastershipService;
    private IntentService intentService;
    private FlowRuleService flowService;
    private StatisticService flowStatsService;
    private PortStatisticsService portStatsService;
    private TopologyService topologyService;
    private TunnelService tunnelService;
    private UiExtensionService uiextService;
    private UiPreferencesService prefService;
    private static Map<String, ObjectNode> metaUi = new ConcurrentHashMap();

    public Topo2Jsonifier(ServiceDirectory directory, String userName) {
        this.directory = (ServiceDirectory)Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.userName = (String)Preconditions.checkNotNull((Object)userName, (Object)"User name cannot be null");
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.intentService = (IntentService)directory.get(IntentService.class);
        this.flowService = (FlowRuleService)directory.get(FlowRuleService.class);
        this.flowStatsService = (StatisticService)directory.get(StatisticService.class);
        this.portStatsService = (PortStatisticsService)directory.get(PortStatisticsService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        this.tunnelService = (TunnelService)directory.get(TunnelService.class);
        this.uiextService = (UiExtensionService)directory.get(UiExtensionService.class);
        this.prefService = (UiPreferencesService)directory.get(UiPreferencesService.class);
    }

    Topo2Jsonifier() {
        this.userName = "(unit-test)";
    }

    private ObjectNode objectNode() {
        return this.mapper.createObjectNode();
    }

    private ArrayNode arrayNode() {
        return this.mapper.createArrayNode();
    }

    private String nullIsEmpty(Object o) {
        return o == null ? NO_CONTEXT : o.toString();
    }

    ObjectNode instances(List<UiClusterMember> instances) {
        NodeId local = this.clusterService.getLocalNode().id();
        ObjectNode payload = this.objectNode();
        ArrayNode members = this.arrayNode();
        payload.set("members", (JsonNode)members);
        for (UiClusterMember member : instances) {
            members.add((JsonNode)this.json(member, member.id().equals((Object)local)));
        }
        return payload;
    }

    private ObjectNode json(UiClusterMember member, boolean isUiAttached) {
        int switchCount = this.mastershipService.getDevicesOf(member.id()).size();
        return this.objectNode().put("id", member.id().toString()).put("ip", member.ip().toString()).put("online", member.isOnline()).put("ready", member.isReady()).put("uiAttached", isUiAttached).put("switches", switchCount);
    }

    ObjectNode layout(UiTopoLayout layout, List<UiTopoLayout> crumbs) {
        ObjectNode result = this.objectNode().put("id", layout.id().toString()).put("parent", this.nullIsEmpty((Object)layout.parent())).put(REGION, this.nullIsEmpty((Object)layout.regionId())).put("regionName", UiRegion.safeName((Region)layout.region()));
        this.addCrumbs(result, crumbs);
        this.addBgRef(result, layout);
        return result;
    }

    private void addBgRef(ObjectNode result, UiTopoLayout layout) {
        String mapId = layout.geomap();
        String sprId = layout.sprites();
        if (mapId != null) {
            result.put("bgType", GEO).put("bgId", mapId);
            this.addMapParameters(result, mapId);
        } else if (sprId != null) {
            result.put("bgType", GRID).put("bgId", sprId);
        }
        this.attachZoomData(result, layout);
    }

    private void attachZoomData(ObjectNode result, UiTopoLayout layout) {
        ObjectNode zoomData = this.objectNode();
        this.addCfgZoomData(zoomData, layout);
        String rid = layout.regionId().toString();
        ObjectNode userZoom = (ObjectNode)metaUi.get(this.contextKey(rid, ZOOM_KEY));
        if (userZoom != null) {
            zoomData.set("usr", (JsonNode)userZoom);
        }
        result.set("bgZoom", (JsonNode)zoomData);
    }

    private void addCfgZoomData(ObjectNode data, UiTopoLayout layout) {
        ObjectNode zoom = this.objectNode();
        zoom.put("scale", layout.scale());
        zoom.put("offsetX", layout.offsetX());
        zoom.put("offsetY", layout.offsetY());
        data.set("cfg", (JsonNode)zoom);
    }

    private void addMapParameters(ObjectNode result, String mapId) {
        UiTopoMap[] map = new UiTopoMap[]{null};
        this.uiextService.getExtensions().forEach(ext -> {
            UiTopoMapFactory factory = ext.topoMapFactory();
            if (map[0] == null && factory != null) {
                List topoMaps = factory.geoMaps();
                topoMaps.forEach(m -> {
                    if (map[0] == null && m.id().equals(mapId)) {
                        map[0] = m;
                    }
                });
            }
        });
        UiTopoMap m = map[0];
        if (m != null) {
            result.put("bgDesc", m.description()).put("bgFilePath", m.filePath()).put("bgDefaultScale", m.scale());
        } else {
            result.put("bgWarn", "no map registered with id: " + mapId);
        }
    }

    private void addCrumbs(ObjectNode result, List<UiTopoLayout> crumbs) {
        ArrayNode trail = this.arrayNode();
        crumbs.forEach(c -> {
            ObjectNode n = this.objectNode().put("id", c.regionId().toString()).put("name", UiRegion.safeName((Region)c.region()));
            trail.add((JsonNode)n);
        });
        result.set("crumbs", (JsonNode)trail);
    }

    ObjectNode region(UiRegion region, Set<UiRegion> subRegions, List<UiSynthLink> links) {
        ObjectNode payload = this.objectNode();
        if (region == null) {
            payload.put("note", "no-region");
            return payload;
        }
        String ridStr = region.idAsString();
        payload.put("id", ridStr);
        payload.set("subregions", (JsonNode)this.jsonSubRegions(ridStr, subRegions));
        payload.set("links", this.jsonLinks(links));
        List layerTags = region.layerOrder();
        List splitDevices = this.splitByLayer(layerTags, region.devices());
        List splitHosts = this.splitByLayer(layerTags, region.hosts());
        payload.set("devices", (JsonNode)this.jsonGrouped(ridStr, splitDevices));
        payload.set("hosts", (JsonNode)this.jsonGrouped(ridStr, splitHosts));
        payload.set("layerOrder", (JsonNode)this.jsonStrings(layerTags));
        if (!region.isRoot()) {
            this.addPeerLocations(payload, region.backingRegion());
        }
        return payload;
    }

    private ArrayNode jsonSubRegions(String ridStr, Set<UiRegion> subregions) {
        ArrayNode kids = this.arrayNode();
        subregions.forEach(s -> kids.add((JsonNode)this.jsonClosedRegion(ridStr, s)));
        return kids;
    }

    protected JsonNode jsonLinks(List<UiSynthLink> links) {
        return this.collateSynthLinks(links);
    }

    private ArrayNode jsonStrings(List<String> strings) {
        ArrayNode array = this.arrayNode();
        strings.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return array;
    }

    private ArrayNode jsonGrouped(String ridStr, List<Set<UiNode>> groupedNodes) {
        ArrayNode result = this.arrayNode();
        groupedNodes.forEach(g -> {
            ArrayNode subset = this.arrayNode();
            g.forEach(n -> subset.add((JsonNode)this.json(ridStr, n)));
            result.add((JsonNode)subset);
        });
        return result;
    }

    public ObjectNode jsonUiElement(UiElement element) {
        if (element instanceof UiNode) {
            return this.json(NO_CONTEXT, (UiNode)element);
        }
        if (element instanceof UiLink) {
            return this.json((UiLink)element);
        }
        return this.objectNode().put("warning", "unknown UiElement... cannot encode").put("javaclass", element.getClass().toString());
    }

    public ObjectNode jsonEvent(UiModelEvent modelEvent) {
        ObjectNode payload = this.objectNode();
        payload.put(TYPE, this.enumToString(modelEvent.type()));
        payload.put(SUBJECT, ((UiElement)modelEvent.subject()).idAsString());
        payload.set(DATA, (JsonNode)modelEvent.data());
        payload.put(MEMO, modelEvent.memo());
        return payload;
    }

    private String enumToString(Enum<?> e) {
        return e.toString();
    }

    private String master(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        return master != null ? master.toString() : NO_CONTEXT;
    }

    private ObjectNode json(String ridStr, UiNode node) {
        if (node instanceof UiRegion) {
            return this.jsonClosedRegion(ridStr, (UiRegion)node);
        }
        if (node instanceof UiDevice) {
            return this.json(ridStr, (UiDevice)node);
        }
        if (node instanceof UiHost) {
            return this.json(ridStr, (UiHost)node);
        }
        throw new IllegalStateException(E_UNKNOWN_UI_NODE + node.getClass());
    }

    private ObjectNode json(String ridStr, UiDevice device) {
        ObjectNode node = this.objectNode().put("id", device.idAsString()).put("nodeType", DEVICE).put(TYPE, device.type()).put("online", this.deviceService.isAvailable(device.id())).put("master", this.master(device.id())).put("layer", device.layer());
        Device d = device.backingDevice();
        if (d != null) {
            this.addProps(node, (Annotated)d);
            this.addGeoGridLocation(node, (Annotated)d);
        }
        this.addMetaUi(node, ridStr, device.idAsString());
        return node;
    }

    private void addProps(ObjectNode node, Annotated a) {
        Annotations annot = a.annotations();
        ObjectNode props = this.objectNode();
        if (annot != null) {
            annot.keys().forEach(k -> props.put(k, annot.value(k)));
        }
        node.set("props", (JsonNode)props);
    }

    private void addMetaUi(ObjectNode node, String ridStr, String metaInstanceId) {
        String key = this.contextKey(ridStr, metaInstanceId);
        ObjectNode meta = (ObjectNode)metaUi.get(key);
        if (meta != null) {
            node.set("metaUi", (JsonNode)meta);
        }
    }

    private void addGeoGridLocation(ObjectNode node, Annotated a) {
        List latLongData = this.getAnnotValues(a, new String[]{"latitude", "longitude"});
        List gridYXdata = this.getAnnotValues(a, new String[]{"gridY", "gridX"});
        if (latLongData != null) {
            this.attachLocation(node, GEO, latLongData);
        } else if (gridYXdata != null) {
            this.attachLocation(node, GRID, gridYXdata);
        }
    }

    private void attachLocation(ObjectNode node, String locType, List<String> values) {
        try {
            double latOrY = Double.parseDouble(values.get(0));
            double longOrX = Double.parseDouble(values.get(1));
            ObjectNode loc = this.objectNode().put(LOC_TYPE, locType).put(LAT_OR_Y, latOrY).put(LONG_OR_X, longOrX);
            node.set(LOCATION, (JsonNode)loc);
        }
        catch (NumberFormatException e) {
            this.log.warn("Invalid {} data: lat/Y={}, long/X={}", new Object[]{locType, values.get(0), values.get(1)});
        }
    }

    private void addPeerLocations(ObjectNode node, Region r) {
        String compact = r.annotations().value(PEER_LOCATIONS);
        if (!Strings.isNullOrEmpty((String)compact)) {
            List locs = LayoutLocation.fromCompactListString((String)compact);
            ObjectNode o = this.objectNode();
            for (LayoutLocation ll : locs) {
                ObjectNode lnode = this.objectNode().put(LOC_TYPE, ll.locType().toString()).put(LAT_OR_Y, ll.latOrY()).put(LONG_OR_X, ll.longOrX());
                o.set(ll.id(), (JsonNode)lnode);
            }
            node.set(PEER_LOCATIONS, (JsonNode)o);
        }
    }

    private void addIps(ObjectNode node, Host h) {
        Set ips = h.ipAddresses();
        ArrayNode a = this.arrayNode();
        for (IpAddress ip : ips) {
            a.add(ip.toString());
        }
        node.set("ips", (JsonNode)a);
    }

    List<String> getAnnotValues(Annotated a, String ... annotKeys) {
        ArrayList<String> result = new ArrayList<String>(annotKeys.length);
        for (String k : annotKeys) {
            String v = a.annotations().value(k);
            if (v == null) {
                return null;
            }
            result.add(v);
        }
        return result;
    }

    private ObjectNode props(Annotations annotations) {
        ObjectNode p = this.objectNode();
        if (annotations != null) {
            annotations.keys().forEach(k -> p.put(k, annotations.value(k)));
        }
        return p;
    }

    private ObjectNode json(String ridStr, UiHost host) {
        ObjectNode node = this.objectNode().put("id", host.idAsString()).put("nodeType", HOST).put("layer", host.layer());
        Host h = host.backingHost();
        if (h != null) {
            this.addIps(node, h);
            this.addProps(node, (Annotated)h);
            this.addGeoGridLocation(node, (Annotated)h);
        }
        this.addMetaUi(node, ridStr, host.idAsString());
        return node;
    }

    private ArrayNode collateSynthLinks(List<UiSynthLink> links) {
        HashMap<UiLinkId, Set> collation = new HashMap<UiLinkId, Set>();
        for (UiSynthLink sl : links) {
            UiLinkId id = sl.link().id();
            Set rollup = collation.computeIfAbsent(id, k -> new HashSet());
            rollup.add(sl);
        }
        ArrayNode array = this.arrayNode();
        for (UiLinkId id : collation.keySet()) {
            array.add((JsonNode)this.json((Set)collation.get(id)));
        }
        return array;
    }

    private ObjectNode json(Set<UiSynthLink> memberSet) {
        ArrayNode rollup = this.arrayNode();
        ObjectNode node = null;
        boolean first = true;
        for (UiSynthLink member : memberSet) {
            UiLink link = member.link();
            if (first) {
                node = this.json(link);
                first = false;
            }
            rollup.add((JsonNode)this.json(member.original()));
        }
        if (node != null) {
            node.set("rollup", (JsonNode)rollup);
        }
        return node;
    }

    private ObjectNode json(UiLink link) {
        ObjectNode data = this.objectNode().put("id", link.idAsString()).put("epA", link.endPointA()).put("epB", link.endPointB()).put(TYPE, link.type());
        String pA = link.endPortA();
        String pB = link.endPortB();
        if (pA != null) {
            data.put("portA", pA);
        }
        if (pB != null) {
            data.put("portB", pB);
        }
        return data;
    }

    private ObjectNode jsonClosedRegion(String ridStr, UiRegion region) {
        ObjectNode node = this.objectNode().put("id", region.idAsString()).put("name", region.name()).put("nodeType", REGION).put("nDevs", region.deviceCount()).put("nHosts", region.hostCount());
        Region r = region.backingRegion();
        if (r != null) {
            this.addGeoGridLocation(node, (Annotated)r);
            this.addProps(node, (Annotated)r);
        }
        this.addMetaUi(node, ridStr, region.idAsString());
        return node;
    }

    public ArrayNode closedNodes(String ridStr, Set<UiNode> nodes) {
        ArrayNode array = this.arrayNode();
        for (UiNode node : nodes) {
            if (node instanceof UiRegion) {
                array.add((JsonNode)this.jsonClosedRegion(ridStr, (UiRegion)node));
                continue;
            }
            if (node instanceof UiDevice) {
                array.add((JsonNode)this.json(ridStr, (UiDevice)node));
                continue;
            }
            this.log.warn("Unexpected node instance: {}", node.getClass());
        }
        return array;
    }

    List<Set<UiNode>> splitByLayer(List<String> layerTags, Set<? extends UiNode> nodes) {
        int nLayers = layerTags.size();
        if (!layerTags.get(nLayers - 1).equals("def")) {
            throw new IllegalArgumentException(E_DEF_NOT_LAST);
        }
        ArrayList<Set<UiNode>> splitList = new ArrayList<Set<UiNode>>(layerTags.size());
        HashMap byLayer = new HashMap(layerTags.size());
        for (String string : layerTags) {
            HashSet set = new HashSet();
            byLayer.put(string, set);
            splitList.add(set);
        }
        for (UiNode uiNode : nodes) {
            String which = uiNode.layer();
            if (!layerTags.contains(which)) {
                which = "def";
            }
            ((Set)byLayer.get(which)).add(uiNode);
        }
        return splitList;
    }

    private String contextKey(String context, String key) {
        return context + CONTEXT_KEY_DELIM + key;
    }

    void updateMeta(String ridStr, ObjectNode payload) {
        String id = JsonUtils.string((ObjectNode)payload, (String)"id");
        String key = this.contextKey(ridStr, id);
        metaUi.put(key, JsonUtils.node((ObjectNode)payload, (String)"memento"));
        this.log.debug("Storing metadata for {}", (Object)key);
    }
}

