/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.impl.UiWebSocket;
import org.onosproject.ui.impl.UiWebSocketServlet;

public class UiWebSocketServlet
extends WebSocketServlet {
    private static final long PING_DELAY_MS = 5000L;
    private static UiWebSocketServlet instance;
    private ServiceDirectory directory = new DefaultServiceDirectory();
    private final Set<UiWebSocket> sockets = new HashSet();
    private final Timer timer = new Timer();
    private final TimerTask pruner = new Pruner(this, null);
    private boolean isStopped = false;
    private static final String FAKE_USERNAME = "UI-user";

    public static void closeAll() {
        if (instance != null) {
            UiWebSocketServlet.instance.isStopped = true;
            UiWebSocketServlet.instance.sockets.forEach(UiWebSocket::close);
            UiWebSocketServlet.instance.sockets.clear();
            UiWebSocketServlet.instance.pruner.cancel();
            UiWebSocketServlet.instance.timer.cancel();
        }
    }

    public void init() throws ServletException {
        super.init();
        instance = this;
        this.timer.schedule(this.pruner, 5000L, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        if (this.isStopped) {
            return null;
        }
        Principal p = request.getUserPrincipal();
        String userName = p != null ? p.getName() : FAKE_USERNAME;
        UiWebSocket socket = new UiWebSocket(this.directory, userName);
        Set set = this.sockets;
        synchronized (set) {
            this.sockets.add(socket);
        }
        return socket;
    }

    static void sendToAll(String type, ObjectNode payload) {
        if (instance != null) {
            UiWebSocketServlet.instance.sockets.forEach(ws -> ws.sendMessage(type, payload));
        }
    }

    static void sendToUser(String userName, String type, ObjectNode payload) {
        if (instance != null) {
            UiWebSocketServlet.instance.sockets.stream().filter(ws -> userName.equals(ws.userName())).forEach(ws -> ws.sendMessage(type, payload));
        }
    }

    static /* synthetic */ Set access$100(UiWebSocketServlet x0) {
        return x0.sockets;
    }
}

