/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.mastership.MastershipService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiPreferencesService;
import org.onosproject.ui.UiSessionToken;
import org.onosproject.ui.UiTokenService;
import org.onosproject.ui.UiTopo2OverlayFactory;
import org.onosproject.ui.UiTopoMap;
import org.onosproject.ui.UiTopoMapFactory;
import org.onosproject.ui.UiTopoOverlayFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.UiViewHidden;
import org.onosproject.ui.impl.ApplicationViewMessageHandler;
import org.onosproject.ui.impl.ClusterViewMessageHandler;
import org.onosproject.ui.impl.DeviceViewMessageHandler;
import org.onosproject.ui.impl.FlowViewMessageHandler;
import org.onosproject.ui.impl.GroupViewMessageHandler;
import org.onosproject.ui.impl.HostViewMessageHandler;
import org.onosproject.ui.impl.IntentViewMessageHandler;
import org.onosproject.ui.impl.LinkViewMessageHandler;
import org.onosproject.ui.impl.MapSelectorMessageHandler;
import org.onosproject.ui.impl.MeterViewMessageHandler;
import org.onosproject.ui.impl.PartitionViewMessageHandler;
import org.onosproject.ui.impl.PortViewMessageHandler;
import org.onosproject.ui.impl.ProcessorViewMessageHandler;
import org.onosproject.ui.impl.ProtectedIntentOverlay;
import org.onosproject.ui.impl.SettingsViewMessageHandler;
import org.onosproject.ui.impl.SpriteService;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.TrafficOverlay;
import org.onosproject.ui.impl.TunnelViewMessageHandler;
import org.onosproject.ui.impl.UiExtensionManager;
import org.onosproject.ui.impl.UiWebSocketServlet;
import org.onosproject.ui.impl.UserPreferencesMessageHandler;
import org.onosproject.ui.impl.topo.Topo2TrafficMessageHandler;
import org.onosproject.ui.impl.topo.Topo2ViewMessageHandler;
import org.onosproject.ui.impl.topo.Traffic2Overlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(immediate=true)
@Service
public class UiExtensionManager
implements UiExtensionService,
UiPreferencesService,
SpriteService,
UiTokenService {
    private static final ClassLoader CL = UiExtensionManager.class.getClassLoader();
    private static final String ONOS_USER_PREFERENCES = "onos-ui-user-preferences";
    private static final String ONOS_SESSION_TOKENS = "onos-ui-session-tokens";
    private static final String CORE = "core";
    private static final String GUI_ADDED = "guiAdded";
    private static final String GUI_REMOVED = "guiRemoved";
    private static final String UPDATE_PREFS = "updatePrefs";
    private static final String SLASH = "/";
    private static final int IDX_USER = 0;
    private static final int IDX_KEY = 1;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<UiExtension> extensions = Lists.newArrayList();
    private final Map<String, UiExtension> views = Maps.newHashMap();
    private final UiExtension core = this.createCoreExtension();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<String, ObjectNode> prefsConsistentMap;
    private Map<String, ObjectNode> prefs;
    private final MapEventListener<String, ObjectNode> prefsListener = new InternalPrefsListener(this, null);
    private ConsistentMap<UiSessionToken, String> tokensConsistentMap;
    private Map<UiSessionToken, String> tokens;
    private final SessionTokenGenerator tokenGen = new SessionTokenGenerator(this, null);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ExecutorService eventHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/ui-ext-manager", (String)"event-handler", (Logger)this.log));
    private final Map<String, JsonNode> sprites = Maps.newHashMap();

    private UiExtension createCoreExtension() {
        ImmutableList coreViews = ImmutableList.of((Object)new UiView(UiView.Category.PLATFORM, "app", "Applications", "nav_apps"), (Object)new UiView(UiView.Category.PLATFORM, "settings", "Settings", "nav_settings"), (Object)new UiView(UiView.Category.PLATFORM, "cluster", "Cluster Nodes", "nav_cluster"), (Object)new UiView(UiView.Category.PLATFORM, "processor", "Packet Processors", "nav_processors"), (Object)new UiView(UiView.Category.PLATFORM, "partition", "Partitions", "nav_partitions"), (Object)new UiView(UiView.Category.NETWORK, "topo", "Topology", "nav_topo"), (Object)new UiView(UiView.Category.NETWORK, "topo2", "Topology 2", "nav_topo2"), (Object)new UiView(UiView.Category.NETWORK, "device", "Devices", "nav_devs"), (Object)new UiViewHidden("flow"), (Object)new UiViewHidden("port"), (Object)new UiViewHidden("group"), (Object)new UiViewHidden("meter"), (Object[])new UiView[]{new UiView(UiView.Category.NETWORK, "link", "Links", "nav_links"), new UiView(UiView.Category.NETWORK, "host", "Hosts", "nav_hosts"), new UiView(UiView.Category.NETWORK, "intent", "Intents", "nav_intents"), new UiView(UiView.Category.NETWORK, "tunnel", "Tunnels", "nav_tunnels")});
        UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)new UserPreferencesMessageHandler(), (Object)new TopologyViewMessageHandler(), (Object)new Topo2ViewMessageHandler(), (Object)new Topo2TrafficMessageHandler(), (Object)new MapSelectorMessageHandler(), (Object)new DeviceViewMessageHandler(), (Object)new LinkViewMessageHandler(), (Object)new HostViewMessageHandler(), (Object)new FlowViewMessageHandler(), (Object)new PortViewMessageHandler(), (Object)new GroupViewMessageHandler(), (Object)new MeterViewMessageHandler(), (Object[])new UiMessageHandler[]{new IntentViewMessageHandler(), new ApplicationViewMessageHandler(), new SettingsViewMessageHandler(), new ClusterViewMessageHandler(), new ProcessorViewMessageHandler(), new TunnelViewMessageHandler(), new PartitionViewMessageHandler()});
        UiTopoOverlayFactory topoOverlayFactory = () -> ImmutableList.of((Object)new TrafficOverlay(), (Object)new ProtectedIntentOverlay());
        UiTopo2OverlayFactory topo2OverlayFactory = () -> ImmutableList.of((Object)new Traffic2Overlay());
        UiTopoMapFactory topoMapFactory = () -> ImmutableList.of((Object)new UiTopoMap("australia", "Australia", "*australia", 1.0), (Object)new UiTopoMap("americas", "North, Central and South America", "*americas", 0.7), (Object)new UiTopoMap("n_america", "North America", "*n_america", 0.9), (Object)new UiTopoMap("s_america", "South America", "*s_america", 0.9), (Object)new UiTopoMap("usa", "United States", "*continental_us", 1.3), (Object)new UiTopoMap("bayareaGEO", "Bay Area, California", "*bayarea", 1.0), (Object)new UiTopoMap("europe", "Europe", "*europe", 10.0), (Object)new UiTopoMap("italy", "Italy", "*italy", 0.8), (Object)new UiTopoMap("uk", "United Kingdom and Ireland", "*uk", 2.0), (Object)new UiTopoMap("japan", "Japan", "*japan", 0.8), (Object)new UiTopoMap("s_korea", "South Korea", "*s_korea", 0.75), (Object)new UiTopoMap("taiwan", "Taiwan", "*taiwan", 0.7), (Object[])new UiTopoMap[]{new UiTopoMap("africa", "Africa", "*africa", 0.7), new UiTopoMap("oceania", "Oceania", "*oceania", 0.7), new UiTopoMap("asia", "Asia", "*asia", 0.7)});
        return new UiExtension.Builder(CL, (List)coreViews).messageHandlerFactory(messageHandlerFactory).topoOverlayFactory(topoOverlayFactory).topo2OverlayFactory(topo2OverlayFactory).topoMapFactory(topoMapFactory).resourcePath("core").build();
    }

    @Activate
    public void activate() {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{ObjectNode.class, ArrayNode.class, JsonNodeFactory.class, LinkedHashMap.class, TextNode.class, BooleanNode.class, LongNode.class, DoubleNode.class, ShortNode.class, IntNode.class, NullNode.class, UiSessionToken.class});
        this.prefsConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-ui-user-preferences")).withSerializer(serializer)).withRelaxedReadConsistency()).build();
        this.prefsConsistentMap.addListener(this.prefsListener);
        this.prefs = this.prefsConsistentMap.asJavaMap();
        this.tokensConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-ui-session-tokens")).withSerializer(serializer)).withRelaxedReadConsistency()).build();
        this.tokens = this.tokensConsistentMap.asJavaMap();
        this.register(this.core);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.prefsConsistentMap.removeListener(this.prefsListener);
        this.eventHandlingExecutor.shutdown();
        UiWebSocketServlet.closeAll();
        this.unregister(this.core);
        this.log.info("Stopped");
    }

    public synchronized void register(UiExtension extension) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.UI_WRITE);
        if (!this.extensions.contains(extension)) {
            this.extensions.add(extension);
            for (UiView view : extension.views()) {
                this.views.put(view.id(), extension);
            }
            UiWebSocketServlet.sendToAll((String)"guiAdded", null);
        }
    }

    public synchronized void unregister(UiExtension extension) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.UI_WRITE);
        this.extensions.remove(extension);
        extension.views().stream().map(UiView::id).collect(Collectors.toSet()).forEach(this.views::remove);
        UiWebSocketServlet.sendToAll((String)"guiRemoved", null);
    }

    public synchronized List<UiExtension> getExtensions() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.UI_READ);
        return ImmutableList.copyOf((Collection)this.extensions);
    }

    public synchronized UiExtension getViewExtension(String viewId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.UI_READ);
        return (UiExtension)this.views.get(viewId);
    }

    public Set<String> getUserNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.prefs.keySet().forEach(k -> builder.add((Object)this.userName(k)));
        return builder.build();
    }

    public Map<String, ObjectNode> getPreferences(String userName) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.prefs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(userName + "/")).forEach(e -> builder.put((Object)this.keyName((String)e.getKey()), e.getValue()));
        return builder.build();
    }

    public void setPreference(String userName, String preference, ObjectNode value) {
        this.prefs.put(this.key(userName, preference), value);
    }

    public Set<String> getNames() {
        return ImmutableSet.copyOf(this.sprites.keySet());
    }

    public void put(String name, JsonNode spriteData) {
        this.log.info("Registered sprite definition [{}]", (Object)name);
        this.sprites.put(name, spriteData);
    }

    public JsonNode get(String name) {
        return (JsonNode)this.sprites.get(name);
    }

    private String key(String userName, String keyName) {
        return userName + "/" + keyName;
    }

    private String userName(String key) {
        return key.split("/")[0];
    }

    private String keyName(String key) {
        return key.split("/")[1];
    }

    public UiSessionToken issueToken(String username) {
        UiSessionToken token = new UiSessionToken(SessionTokenGenerator.access$200((SessionTokenGenerator)this.tokenGen));
        this.tokens.put(token, username);
        this.log.debug("UiSessionToken issued: {}", (Object)token);
        return token;
    }

    public void revokeToken(UiSessionToken token) {
        if (token != null) {
            this.tokens.remove(token);
            this.log.debug("UiSessionToken revoked: {}", (Object)token);
        }
    }

    public boolean isTokenValid(UiSessionToken token) {
        return token != null && this.tokens.containsKey(token);
    }

    static /* synthetic */ ExecutorService access$300(UiExtensionManager x0) {
        return x0.eventHandlingExecutor;
    }

    static /* synthetic */ ObjectMapper access$400(UiExtensionManager x0) {
        return x0.mapper;
    }

    static /* synthetic */ Map access$500(UiExtensionManager x0) {
        return x0.prefs;
    }

    static /* synthetic */ String access$600(UiExtensionManager x0, String x1) {
        return x0.keyName(x1);
    }

    static /* synthetic */ String access$700(UiExtensionManager x0, String x1) {
        return x0.userName(x1);
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

