/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.statistic.Load;
import org.onosproject.ui.impl.TrafficMonitorBase;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.impl.topo.util.TrafficLinkMap;
import org.onosproject.ui.topo.AbstractTopoMonitor;
import org.onosproject.ui.topo.Highlights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrafficMonitorBase
extends AbstractTopoMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final double BPS_THRESHOLD = 4096.0;
    protected final long trafficPeriod;
    protected final ServicesBundle services;
    protected Mode mode = Mode.IDLE;
    private final Timer timer;
    private TimerTask trafficTask = null;

    protected TrafficMonitorBase(long trafficPeriod, ServicesBundle servicesBundle) {
        this.trafficPeriod = trafficPeriod;
        this.services = servicesBundle;
        this.timer = new Timer("uiTopo-" + this.getClass().getSimpleName());
    }

    public synchronized void monitor(Mode mode) {
        this.mode = mode;
        switch (1.$SwitchMap$org$onosproject$ui$impl$TrafficMonitorBase$Mode[mode.ordinal()]) {
            case 1: {
                this.clearSelection();
                this.scheduleTask();
                this.sendAllFlowTraffic();
                break;
            }
            case 2: {
                this.clearSelection();
                this.scheduleTask();
                this.sendAllPortTrafficBits();
                break;
            }
            case 3: {
                this.clearSelection();
                this.scheduleTask();
                this.sendAllPortTrafficPackets();
                break;
            }
            case 4: {
                this.sendSelectedIntentTraffic();
                this.scheduleTask();
                break;
            }
            default: {
                this.log.warn("Unexpected call to monitor({})", (Object)mode);
                this.clearAll();
            }
        }
    }

    protected abstract void sendAllFlowTraffic();

    protected abstract void sendAllPortTrafficBits();

    protected abstract void sendAllPortTrafficPackets();

    protected abstract void sendDeviceLinkFlows();

    protected abstract void sendSelectedIntentTraffic();

    protected abstract void sendClearHighlights();

    protected abstract void clearSelection();

    protected void clearAll() {
        this.mode = Mode.IDLE;
        this.clearSelection();
        this.cancelTask();
        this.sendClearHighlights();
    }

    protected synchronized void scheduleTask() {
        if (this.trafficTask == null) {
            this.log.debug("Starting up background traffic task...");
            this.trafficTask = new TrafficUpdateTask(this, null);
            this.timer.schedule(this.trafficTask, this.trafficPeriod, this.trafficPeriod);
        } else {
            this.log.debug("(traffic task already running)");
        }
    }

    protected synchronized void cancelTask() {
        if (this.trafficTask != null) {
            this.trafficTask.cancel();
            this.trafficTask = null;
        }
    }

    public synchronized void stopMonitoring() {
        this.log.debug("STOP monitoring");
        if (this.mode != Mode.IDLE) {
            this.clearAll();
        }
    }

    protected Highlights trafficSummary(TrafficLink.StatsType type) {
        Highlights highlights = new Highlights();
        Set linksWithTraffic = this.computeLinksWithTraffic(type);
        Set aggregatedLinks = this.doAggregation(linksWithTraffic);
        for (TrafficLink tlink : aggregatedLinks) {
            highlights.add(tlink.highlight((Enum)type));
        }
        return highlights;
    }

    protected Set<TrafficLink> computeLinksWithTraffic(TrafficLink.StatsType type) {
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.compileLinks(linkMap);
        this.addEdgeLinks(linkMap);
        HashSet<TrafficLink> linksWithTraffic = new HashSet<TrafficLink>();
        for (TrafficLink tlink : linkMap.biLinks()) {
            if (type == TrafficLink.StatsType.FLOW_STATS) {
                this.attachFlowLoad(tlink);
            } else if (type == TrafficLink.StatsType.PORT_STATS) {
                this.attachPortLoad(tlink, PortStatisticsService.MetricType.BYTES);
            } else if (type == TrafficLink.StatsType.PORT_PACKET_STATS) {
                this.attachPortLoad(tlink, PortStatisticsService.MetricType.PACKETS);
            }
            if (!tlink.hasTraffic()) continue;
            linksWithTraffic.add(tlink);
        }
        return linksWithTraffic;
    }

    protected void compileLinks(TrafficLinkMap linkMap) {
        this.services.link().getLinks().forEach(arg_0 -> ((TrafficLinkMap)linkMap).add(arg_0));
    }

    protected void addEdgeLinks(TrafficLinkMap linkMap) {
        this.services.host().getHosts().forEach(host -> {
            linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)true));
            linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)false));
        });
    }

    protected void attachFlowLoad(TrafficLink link) {
        link.addLoad(this.getLinkFlowLoad(link.one()));
        link.addLoad(this.getLinkFlowLoad(link.two()));
    }

    protected Load getLinkFlowLoad(Link link) {
        if (link != null && link.src().elementId() instanceof DeviceId) {
            return this.services.flowStats().load(link);
        }
        return null;
    }

    protected void attachPortLoad(TrafficLink link, PortStatisticsService.MetricType metricType) {
        Link one = link.one();
        Load egressSrc = this.services.portStats().load(one.src(), metricType);
        Load egressDst = this.services.portStats().load(one.dst(), metricType);
        link.addLoad(this.maxLoad(egressSrc, egressDst), metricType == PortStatisticsService.MetricType.BYTES ? 4096.0 : 0.0);
    }

    protected Load maxLoad(Load a, Load b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.rate() > b.rate() ? a : b;
    }

    protected Set<TrafficLink> doAggregation(Set<TrafficLink> linksWithTraffic) {
        return linksWithTraffic;
    }

    static /* synthetic */ Logger access$100(TrafficMonitorBase x0) {
        return x0.log;
    }
}

