/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.link.LinkService;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.TrafficMonitor;
import org.onosproject.ui.impl.TrafficMonitorBase;
import org.onosproject.ui.impl.topo.util.IntentSelection;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.impl.topo.util.TopoIntentFilter;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.impl.topo.util.TrafficLinkMap;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.NodeHighlight;
import org.onosproject.ui.topo.NodeSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficMonitor
extends TrafficMonitorBase {
    private static final Logger log = LoggerFactory.getLogger(TrafficMonitor.class);
    private final TopologyViewMessageHandler msgHandler;
    private final TopoIntentFilter intentFilter;
    private NodeSelection selectedNodes = null;
    private IntentSelection selectedIntents = null;

    public TrafficMonitor(long trafficPeriod, ServicesBundle servicesBundle, TopologyViewMessageHandler msgHandler) {
        super(trafficPeriod, servicesBundle);
        this.msgHandler = msgHandler;
        this.intentFilter = new TopoIntentFilter(servicesBundle);
    }

    public synchronized void monitor(TrafficMonitorBase.Mode mode, NodeSelection nodeSelection) {
        log.debug("monitor: {} -- {}", (Object)mode, (Object)nodeSelection);
        this.mode = mode;
        this.selectedNodes = nodeSelection;
        switch (1.$SwitchMap$org$onosproject$ui$impl$TrafficMonitorBase$Mode[mode.ordinal()]) {
            case 1: {
                if (this.selectedNodes.devicesWithHover().isEmpty()) {
                    this.clearAll();
                    break;
                }
                this.scheduleTask();
                this.sendDeviceLinkFlows();
                break;
            }
            case 2: {
                if (this.selectedNodes.none()) {
                    this.clearAll();
                    break;
                }
                this.selectedIntents = new IntentSelection(this.selectedNodes, this.intentFilter);
                if (this.selectedIntents.none()) {
                    this.clearAll();
                    break;
                }
                this.sendSelectedIntents();
                break;
            }
            default: {
                log.debug("Unexpected call to monitor({}, {})", (Object)mode, (Object)nodeSelection);
                this.clearAll();
            }
        }
    }

    public synchronized void monitor(Intent intent) {
        log.debug("monitor intent: {}", (Object)intent.id());
        this.selectedNodes = null;
        this.selectedIntents = new IntentSelection(intent);
        this.mode = TrafficMonitorBase.Mode.SELECTED_INTENT;
        this.scheduleTask();
        this.sendSelectedIntentTraffic();
    }

    public synchronized void selectNextIntent() {
        if (this.selectedIntents != null) {
            this.selectedIntents.next();
            this.sendSelectedIntents();
            if (this.mode == TrafficMonitorBase.Mode.SELECTED_INTENT) {
                this.mode = TrafficMonitorBase.Mode.RELATED_INTENTS;
            }
        }
    }

    public synchronized void selectPreviousIntent() {
        if (this.selectedIntents != null) {
            this.selectedIntents.prev();
            this.sendSelectedIntents();
            if (this.mode == TrafficMonitorBase.Mode.SELECTED_INTENT) {
                this.mode = TrafficMonitorBase.Mode.RELATED_INTENTS;
            }
        }
    }

    public synchronized void pokeIntent() {
        if (this.mode == TrafficMonitorBase.Mode.SELECTED_INTENT) {
            this.sendSelectedIntentTraffic();
        }
    }

    protected void sendAllFlowTraffic() {
        log.debug("sendAllFlowTraffic");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.FLOW_STATS));
    }

    protected void sendAllPortTrafficBits() {
        log.debug("sendAllPortTrafficBits");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.PORT_STATS));
    }

    protected void sendAllPortTrafficPackets() {
        log.debug("sendAllPortTrafficPackets");
        this.msgHandler.sendHighlights(this.trafficSummary(TrafficLink.StatsType.PORT_PACKET_STATS));
    }

    protected void sendDeviceLinkFlows() {
        log.debug("sendDeviceLinkFlows: {}", (Object)this.selectedNodes);
        this.msgHandler.sendHighlights(this.deviceLinkFlows());
    }

    protected void sendSelectedIntentTraffic() {
        log.debug("sendSelectedIntentTraffic: {}", (Object)this.selectedIntents);
        this.msgHandler.sendHighlights(this.intentTraffic());
    }

    protected void sendClearHighlights() {
        log.debug("sendClearHighlights");
        this.msgHandler.sendHighlights(new Highlights());
    }

    protected void clearSelection() {
        this.selectedNodes = null;
        this.selectedIntents = null;
    }

    private void sendSelectedIntents() {
        log.debug("sendSelectedIntents: {}", (Object)this.selectedIntents);
        this.msgHandler.sendHighlights(this.intentGroup());
    }

    private Highlights deviceLinkFlows() {
        Highlights highlights = new Highlights();
        if (this.selectedNodes != null && !this.selectedNodes.devicesWithHover().isEmpty()) {
            TrafficLinkMap linkMap = new TrafficLinkMap();
            for (Device device : this.selectedNodes.devicesWithHover()) {
                Map counts = this.getLinkFlowCounts(device.id());
                for (Link link : counts.keySet()) {
                    TrafficLink tlink = (TrafficLink)linkMap.add(link);
                    tlink.addFlows(((Integer)counts.get(link)).intValue());
                }
            }
            for (TrafficLink tlink : linkMap.biLinks()) {
                highlights.add(tlink.highlight((Enum)TrafficLink.StatsType.FLOW_COUNT));
            }
        }
        return highlights;
    }

    private Highlights intentGroup() {
        Highlights highlights = new Highlights();
        if (this.selectedIntents != null && !this.selectedIntents.none()) {
            Set secondary;
            HashSet primary;
            int count = this.selectedIntents.size();
            HashSet allBut = new HashSet(this.selectedIntents.intents());
            if (this.selectedIntents.all()) {
                primary = allBut;
                secondary = Collections.emptySet();
                log.debug("Highlight all intents ({})", (Object)count);
            } else {
                Intent current = this.selectedIntents.current();
                primary = new HashSet();
                primary.add(current);
                allBut.remove(current);
                secondary = allBut;
                log.debug("Highlight intent: {} ([{}] of {})", new Object[]{current.id(), this.selectedIntents.index(), count});
            }
            this.highlightIntentLinks(highlights, primary, secondary);
        }
        return highlights;
    }

    private Highlights intentTraffic() {
        Highlights highlights = new Highlights();
        if (this.selectedIntents != null && this.selectedIntents.single()) {
            Intent current = this.selectedIntents.current();
            HashSet<Intent> primary = new HashSet<Intent>();
            primary.add(current);
            log.debug("Highlight traffic for intent: {} ([{}] of {})", new Object[]{current.id(), this.selectedIntents.index(), this.selectedIntents.size()});
            this.highlightIntentLinksWithTraffic(highlights, primary);
            highlights.subdueAllElse(Highlights.Amount.MINIMALLY);
        }
        return highlights;
    }

    private Map<Link, Integer> getLinkFlowCounts(DeviceId deviceId) {
        ArrayList<FlowEntry> entries = new ArrayList<FlowEntry>();
        for (FlowEntry flowEntry : this.services.flow().getFlowEntries(deviceId)) {
            entries.add(flowEntry);
        }
        HashSet<DefaultEdgeLink> links = new HashSet<DefaultEdgeLink>(this.services.link().getDeviceEgressLinks(deviceId));
        Set hosts = this.services.host().getConnectedHosts(deviceId);
        if (hosts != null) {
            for (Host host : hosts) {
                links.add(DefaultEdgeLink.createEdgeLink((Host)host, (boolean)false));
            }
        }
        HashMap<Link, Integer> counts = new HashMap<Link, Integer>();
        for (Link link : links) {
            counts.put(link, this.getEgressFlows(link, entries));
        }
        return counts;
    }

    private int getEgressFlows(Link link, List<FlowEntry> entries) {
        int count = 0;
        PortNumber out = link.src().port();
        for (FlowEntry entry : entries) {
            TrafficTreatment treatment = entry.treatment();
            for (Instruction instruction : treatment.allInstructions()) {
                if (instruction.type() != Instruction.Type.OUTPUT || !((Instructions.OutputInstruction)instruction).port().equals((Object)out)) continue;
                ++count;
            }
        }
        return count;
    }

    private void highlightIntentLinks(Highlights highlights, Set<Intent> primary, Set<Intent> secondary) {
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.createTrafficLinks(highlights, linkMap, secondary, LinkHighlight.Flavor.SECONDARY_HIGHLIGHT, false);
        this.createTrafficLinks(highlights, linkMap, primary, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, false);
        this.colorLinks(highlights, linkMap);
    }

    private void highlightIntentLinksWithTraffic(Highlights highlights, Set<Intent> primary) {
        TrafficLinkMap linkMap = new TrafficLinkMap();
        this.createTrafficLinks(highlights, linkMap, primary, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, true);
        this.colorLinks(highlights, linkMap);
    }

    private void createTrafficLinks(Highlights highlights, TrafficLinkMap linkMap, Set<Intent> intents, LinkHighlight.Flavor flavor, boolean showTraffic) {
        for (Intent intent : intents) {
            List installables = this.services.intent().getInstallableIntents(intent.key());
            ArrayList links = null;
            if (installables == null) continue;
            for (Intent installable : installables) {
                if (installable instanceof PathIntent) {
                    links = ((PathIntent)installable).path().links();
                } else if (installable instanceof FlowRuleIntent) {
                    ArrayList l = new ArrayList();
                    l.addAll(this.linkResources(installable));
                    if (intent instanceof OpticalConnectivityIntent) {
                        OpticalConnectivityIntent ocIntent = (OpticalConnectivityIntent)intent;
                        LinkService linkService = this.services.link();
                        DeviceService deviceService = this.services.device();
                        l.addAll(linkService.getDeviceIngressLinks(ocIntent.getSrc().deviceId()).stream().filter(i -> deviceService.getDevice(i.src().deviceId()).type() == Device.Type.SWITCH).collect(Collectors.toList()));
                        l.addAll(linkService.getDeviceEgressLinks(ocIntent.getDst().deviceId()).stream().filter(e -> deviceService.getDevice(e.dst().deviceId()).type() == Device.Type.SWITCH).collect(Collectors.toList()));
                    }
                    links = l;
                } else if (installable instanceof FlowObjectiveIntent) {
                    links = this.linkResources(installable);
                } else if (installable instanceof LinkCollectionIntent) {
                    links = ((LinkCollectionIntent)installable).links();
                } else if (installable instanceof OpticalPathIntent) {
                    links = ((OpticalPathIntent)installable).path().links();
                }
                if (links == null) {
                    links = Lists.newArrayList();
                }
                links = this.addEdgeLinksIfNeeded(intent, (Collection)Lists.newArrayList((Iterable)links));
                boolean isOptical = intent instanceof OpticalConnectivityIntent;
                this.processLinks(linkMap, links, flavor, isOptical, showTraffic);
                this.updateHighlights(highlights, links);
            }
        }
    }

    private Iterable<Link> addEdgeLinksIfNeeded(Intent parentIntent, Collection<Link> links) {
        if (parentIntent instanceof HostToHostIntent) {
            links = new HashSet<Link>(links);
            HostToHostIntent h2h = (HostToHostIntent)parentIntent;
            Host h1 = this.services.host().getHost(h2h.one());
            Host h2 = this.services.host().getHost(h2h.two());
            links.add((Link)DefaultEdgeLink.createEdgeLink((Host)h1, (boolean)true));
            links.add((Link)DefaultEdgeLink.createEdgeLink((Host)h2, (boolean)true));
        }
        return links;
    }

    private void updateHighlights(Highlights highlights, Iterable<Link> links) {
        for (Link link : links) {
            this.ensureNodePresent(highlights, link.src().elementId());
            this.ensureNodePresent(highlights, link.dst().elementId());
        }
    }

    private void ensureNodePresent(Highlights highlights, ElementId eid) {
        String id = eid.toString();
        NodeHighlight nh = highlights.getNode(id);
        if (nh == null) {
            if (eid instanceof DeviceId) {
                nh = new DeviceHighlight(id);
                highlights.add((DeviceHighlight)nh);
            } else if (eid instanceof HostId) {
                nh = new HostHighlight(id);
                highlights.add((HostHighlight)nh);
            }
        }
    }

    private Collection<Link> linkResources(Intent installable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        installable.resources().stream().filter(r -> r instanceof Link).forEach(r -> builder.add((Object)((Link)r)));
        return builder.build();
    }

    private void processLinks(TrafficLinkMap linkMap, Iterable<Link> links, LinkHighlight.Flavor flavor, boolean isOptical, boolean showTraffic) {
        if (links != null) {
            for (Link link : links) {
                TrafficLink tlink = (TrafficLink)linkMap.add(link);
                tlink.tagFlavor(flavor);
                tlink.optical(isOptical);
                if (!showTraffic) continue;
                tlink.addLoad(this.getLinkFlowLoad(link));
                tlink.antMarch(true);
            }
        }
    }

    private void colorLinks(Highlights highlights, TrafficLinkMap linkMap) {
        for (TrafficLink tlink : linkMap.biLinks()) {
            highlights.add(tlink.highlight((Enum)TrafficLink.StatsType.TAGGED));
        }
    }
}

