/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.util.DefaultHashMap;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.topo.PropertyPanel;
import org.onosproject.ui.topo.TopoConstants;
import org.onosproject.ui.topo.TopoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopologyViewMessageHandlerBase
extends UiMessageHandler {
    private static final String NO_GEO_VALUE = "0.0";
    private static final DefaultHashMap<ClusterEvent.Type, String> CLUSTER_EVENT = new DefaultHashMap((Object)"addInstance");
    private static final DefaultHashMap<DeviceEvent.Type, String> DEVICE_EVENT = new DefaultHashMap((Object)"updateDevice");
    private static final DefaultHashMap<LinkEvent.Type, String> LINK_EVENT = new DefaultHashMap((Object)"updateLink");
    private static final DefaultHashMap<HostEvent.Type, String> HOST_EVENT = new DefaultHashMap((Object)"updateHost");
    protected static final Logger log;
    private static final ProviderId PID;
    private static Map<String, ObjectNode> metaUi;
    protected ServicesBundle services;
    private String version;

    static Map<String, ObjectNode> getMetaUi() {
        return Collections.unmodifiableMap(metaUi);
    }

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.services = new ServicesBundle(directory);
        this.setVersionString(directory);
    }

    private void setVersionString(ServiceDirectory directory) {
        String ver = ((CoreService)directory.get(CoreService.class)).version().toString();
        this.version = ver.replace(".SNAPSHOT", "*").replaceFirst("~.*$", "");
    }

    private String ip(Set<IpAddress> ipAddresses) {
        Iterator<IpAddress> it = ipAddresses.iterator();
        return it.hasNext() ? it.next().toString() : "unknown";
    }

    private JsonNode props(Annotations annotations) {
        ObjectNode props = this.objectNode();
        if (annotations != null) {
            for (String key : annotations.keys()) {
                props.put(key, annotations.value(key));
            }
        }
        return props;
    }

    protected ObjectNode info(long id, String message) {
        return this.message("info", id, message);
    }

    protected ObjectNode warning(long id, String message) {
        return this.message("warning", id, message);
    }

    protected ObjectNode error(long id, String message) {
        return this.message("error", id, message);
    }

    private ObjectNode message(String severity, long id, String message) {
        ObjectNode payload = this.objectNode().put("severity", severity).put("message", message);
        return JsonUtils.envelope((String)"message", (long)id, (ObjectNode)payload);
    }

    protected ObjectNode instanceMessage(ClusterEvent event, String msgType) {
        ControllerNode node = (ControllerNode)event.subject();
        int switchCount = this.services.mastership().getDevicesOf(node.id()).size();
        ObjectNode payload = this.objectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("online", this.services.cluster().getState(node.id()).isActive()).put("ready", this.services.cluster().getState(node.id()).isReady()).put("uiAttached", node.equals(this.services.cluster().getLocalNode())).put("switches", switchCount);
        ArrayNode labels = this.arrayNode();
        labels.add(node.id().toString());
        labels.add(node.ip().toString());
        payload.set("labels", (JsonNode)labels);
        this.addMetaUi(node.id().toString(), payload);
        String type = msgType != null ? msgType : (String)CLUSTER_EVENT.get((Object)event.type());
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode deviceMessage(DeviceEvent event) {
        Device device = (Device)event.subject();
        String uiType = device.annotations().value("uiType");
        String devType = uiType != null ? uiType : device.type().toString().toLowerCase();
        ObjectNode payload = this.objectNode().put("id", device.id().toString()).put("type", devType).put("online", this.services.device().isAvailable(device.id())).put("master", this.master(device.id()));
        String name = device.annotations().value("name");
        ArrayNode labels = this.arrayNode();
        labels.add("");
        labels.add(Strings.isNullOrEmpty((String)name) ? device.id().toString() : name);
        labels.add(device.id().toString());
        payload.set("labels", (JsonNode)labels);
        payload.set("props", this.props(device.annotations()));
        this.addGeoLocation((Annotated)device, payload);
        this.addMetaUi(device.id().toString(), payload);
        String type = (String)DEVICE_EVENT.get((Object)event.type());
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode linkMessage(LinkEvent event) {
        Link link = (Link)event.subject();
        ObjectNode payload = this.objectNode().put("id", TopoUtils.compactLinkString((Link)link)).put("type", link.type().toString().toLowerCase()).put("expected", link.isExpected()).put("online", link.state() == Link.State.ACTIVE).put("linkWidth", 1.2).put("src", link.src().deviceId().toString()).put("srcPort", link.src().port().toString()).put("dst", link.dst().deviceId().toString()).put("dstPort", link.dst().port().toString());
        String type = (String)LINK_EVENT.get((Object)event.type());
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode hostMessage(HostEvent event) {
        Host host = (Host)event.subject();
        Host prevHost = event.prevSubject();
        String hostType = host.annotations().value("uiType");
        ObjectNode payload = this.objectNode().put("id", host.id().toString()).put("type", Strings.isNullOrEmpty((String)hostType) ? "endstation" : hostType).put("ingress", TopoUtils.compactLinkString((Link)this.edgeLink(host, true))).put("egress", TopoUtils.compactLinkString((Link)this.edgeLink(host, false)));
        payload.set("cp", (JsonNode)this.hostConnect(host.location()));
        if (prevHost != null && prevHost.location() != null) {
            payload.set("prevCp", (JsonNode)this.hostConnect(prevHost.location()));
        }
        payload.set("labels", (JsonNode)this.labels(new String[]{this.ip(host.ipAddresses()), host.mac().toString()}));
        payload.set("props", this.props(host.annotations()));
        this.addGeoLocation((Annotated)host, payload);
        this.addMetaUi(host.id().toString(), payload);
        String type = (String)HOST_EVENT.get((Object)event.type());
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    private ObjectNode hostConnect(HostLocation location) {
        return this.objectNode().put("device", location.deviceId().toString()).put("port", location.port().toLong());
    }

    private ArrayNode labels(String ... labels) {
        ArrayNode json = this.arrayNode();
        for (String label : labels) {
            json.add(label);
        }
        return json;
    }

    private String master(DeviceId deviceId) {
        NodeId master = this.services.mastership().getMasterFor(deviceId);
        return master != null ? master.toString() : "";
    }

    private EdgeLink edgeLink(Host host, boolean ingress) {
        return new DefaultEdgeLink(PID, new ConnectPoint((ElementId)host.id(), PortNumber.portNumber((long)0L)), host.location(), ingress, new Annotations[0]);
    }

    private void addMetaUi(String id, ObjectNode payload) {
        ObjectNode meta = (ObjectNode)metaUi.get(id);
        if (meta != null) {
            payload.set("metaUi", (JsonNode)meta);
        }
    }

    private void addGeoLocation(Annotated annotated, ObjectNode payload) {
        boolean validLng;
        Annotations annotations = annotated.annotations();
        if (annotations == null) {
            return;
        }
        String slat = annotations.value("latitude");
        String slng = annotations.value("longitude");
        boolean validLat = slat != null && !slat.equals(NO_GEO_VALUE);
        boolean bl = validLng = slng != null && !slng.equals(NO_GEO_VALUE);
        if (validLat && validLng) {
            try {
                double lat = Double.parseDouble(slat);
                double lng = Double.parseDouble(slng);
                ObjectNode loc = this.objectNode().put("locType", "geo").put("latOrY", lat).put("longOrX", lng);
                payload.set("location", (JsonNode)loc);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid geo data: latitude={}, longitude={}", (Object)slat, (Object)slng);
            }
        }
    }

    protected void updateMetaUi(ObjectNode payload) {
        metaUi.put(JsonUtils.string((ObjectNode)payload, (String)"id"), JsonUtils.node((ObjectNode)payload, (String)"memento"));
    }

    protected PropertyPanel summmaryMessage() {
        Topology topology = this.services.topology().currentTopology();
        return new PropertyPanel("ONOS Summary", "node").addProp("Version", this.version).addSeparator().addProp("Devices", this.services.device().getDeviceCount()).addProp("Links", topology.linkCount()).addProp("Hosts", this.services.host().getHostCount()).addProp("Topology SCCs", topology.clusterCount()).addSeparator().addProp("Intents", this.services.intent().getIntentCount()).addProp("Tunnels", this.services.tunnel().tunnelCount()).addProp("Flows", this.services.flow().getFlowRuleCount());
    }

    protected PropertyPanel deviceDetails(DeviceId deviceId) {
        Device device = this.services.device().getDevice(deviceId);
        Annotations annot = device.annotations();
        String name = annot.value("name");
        int portCount = this.services.device().getPorts(deviceId).size();
        int flowCount = this.getFlowCount(deviceId);
        int tunnelCount = this.getTunnelCount(deviceId);
        String title = Strings.isNullOrEmpty((String)name) ? deviceId.toString() : name;
        String typeId = device.type().toString().toLowerCase();
        return new PropertyPanel(title, typeId).id(deviceId.toString()).addProp("URI", deviceId.toString()).addProp("Vendor", device.manufacturer()).addProp("H/W Version", device.hwVersion()).addProp("S/W Version", device.swVersion()).addProp("Serial #", device.serialNumber()).addProp("Protocol", annot.value("protocol")).addSeparator().addProp("Latitude", annot.value("latitude")).addProp("Longitude", annot.value("longitude")).addSeparator().addProp("Ports", portCount).addProp("Flows", flowCount).addProp("Tunnels", tunnelCount).addButton(TopoConstants.CoreButtons.SHOW_DEVICE_VIEW).addButton(TopoConstants.CoreButtons.SHOW_FLOW_VIEW).addButton(TopoConstants.CoreButtons.SHOW_PORT_VIEW).addButton(TopoConstants.CoreButtons.SHOW_GROUP_VIEW).addButton(TopoConstants.CoreButtons.SHOW_METER_VIEW);
    }

    protected int getFlowCount(DeviceId deviceId) {
        int count = 0;
        for (FlowEntry flowEntry : this.services.flow().getFlowEntries(deviceId)) {
            ++count;
        }
        return count;
    }

    protected int getTunnelCount(DeviceId deviceId) {
        int count = 0;
        Collection tunnels = this.services.tunnel().queryAllTunnels();
        for (Tunnel tunnel : tunnels) {
            if (!(tunnel.src() instanceof OpticalTunnelEndPoint) || !(tunnel.dst() instanceof OpticalTunnelEndPoint)) continue;
            Optional srcElementId = ((OpticalTunnelEndPoint)tunnel.src()).elementId();
            Optional dstElementId = ((OpticalTunnelEndPoint)tunnel.dst()).elementId();
            if (!srcElementId.isPresent() || !dstElementId.isPresent()) continue;
            DeviceId srcDeviceId = (DeviceId)srcElementId.get();
            DeviceId dstDeviceId = (DeviceId)dstElementId.get();
            if (!srcDeviceId.equals((Object)deviceId) && !dstDeviceId.equals((Object)deviceId)) continue;
            ++count;
        }
        return count;
    }

    protected PropertyPanel hostDetails(HostId hostId) {
        Host host = this.services.host().getHost(hostId);
        Annotations annot = host.annotations();
        String type = annot.value("type");
        String name = annot.value("name");
        String vlan = host.vlan().toString();
        String title = Strings.isNullOrEmpty((String)name) ? hostId.toString() : name;
        String typeId = Strings.isNullOrEmpty((String)type) ? "endstation" : type;
        return new PropertyPanel(title, typeId).id(hostId.toString()).addProp("MAC", (Object)host.mac()).addProp("IP", (Object)host.ipAddresses(), "[\\[\\]]").addProp("VLAN", "-1".equals(vlan) ? "none" : vlan).addSeparator().addProp("Latitude", annot.value("latitude")).addProp("Longitude", annot.value("longitude"));
    }

    static {
        CLUSTER_EVENT.put((Object)ClusterEvent.Type.INSTANCE_REMOVED, (Object)"removeInstance");
        DEVICE_EVENT.put((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)"addDevice");
        DEVICE_EVENT.put((Object)DeviceEvent.Type.DEVICE_REMOVED, (Object)"removeDevice");
        LINK_EVENT.put((Object)LinkEvent.Type.LINK_ADDED, (Object)"addLink");
        LINK_EVENT.put((Object)LinkEvent.Type.LINK_REMOVED, (Object)"removeLink");
        HOST_EVENT.put((Object)HostEvent.Type.HOST_ADDED, (Object)"addHost");
        HOST_EVENT.put((Object)HostEvent.Type.HOST_REMOVED, (Object)"removeHost");
        HOST_EVENT.put((Object)HostEvent.Type.HOST_MOVED, (Object)"moveHost");
        log = LoggerFactory.getLogger(TopologyViewMessageHandlerBase.class);
        PID = new ProviderId("core", "org.onosproject.core", true);
        metaUi = new ConcurrentHashMap();
    }
}

