/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.MarkerResource;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.ProtectionEndpointIntent;
import org.onosproject.net.link.LinkService;
import org.onosproject.ui.impl.ProtectedIntentMonitor;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.topo.util.ServicesBundle;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.impl.topo.util.TrafficLinkMap;
import org.onosproject.ui.topo.AbstractTopoMonitor;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.Mod;
import org.onosproject.ui.topo.NodeHighlight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedIntentMonitor
extends AbstractTopoMonitor {
    private static final Logger log = LoggerFactory.getLogger(ProtectedIntentMonitor.class);
    private static final String PRIMARY_PATH_TAG = "protection1";
    private static final String PROT_PRIMARY = "protPrimary";
    private static final String PROT_BACKUP = "protBackup";
    private static final Mod MOD_PROT_PRIMARY = new Mod("protPrimary");
    private static final Set<Mod> PROTECTED_MOD_PRIMARY_SET = ImmutableSet.of((Object)MOD_PROT_PRIMARY);
    private static final Mod MOD_PROT_BACKUP = new Mod("protBackup");
    private static final Set<Mod> PROTECTED_MOD_BACKUP_SET = ImmutableSet.of((Object)MOD_PROT_BACKUP);
    private final long trafficPeriod;
    private final ServicesBundle services;
    private final TopologyViewMessageHandler msgHandler;
    private final Timer timer = new Timer("topo-protected-intents");
    private TimerTask trafficTask = null;
    private ProtectedMode mode = ProtectedMode.IDLE;
    private Intent selectedIntent = null;

    public ProtectedIntentMonitor(long trafficPeriod, ServicesBundle services, TopologyViewMessageHandler msgHandler) {
        this.trafficPeriod = trafficPeriod;
        this.services = services;
        this.msgHandler = msgHandler;
    }

    public synchronized void monitor(Intent intent) {
        log.debug("monitor intent: {}", (Object)intent.id());
        this.selectedIntent = intent;
        this.mode = ProtectedMode.SELECTED_INTENT;
        this.scheduleTask();
        this.sendSelectedIntents();
    }

    public synchronized void stopMonitoring() {
        log.debug("STOP monitoring");
        if (this.mode != ProtectedMode.IDLE) {
            this.sendClearAll();
        }
    }

    private void sendClearAll() {
        this.clearAll();
        this.sendClearHighlights();
    }

    private void clearAll() {
        this.mode = ProtectedMode.IDLE;
        this.clearSelection();
        this.cancelTask();
    }

    private void clearSelection() {
        this.selectedIntent = null;
    }

    private synchronized void scheduleTask() {
        if (this.trafficTask == null) {
            log.debug("Starting up background protected intent task...");
            this.trafficTask = new TrafficUpdateTask(this, null);
            this.timer.schedule(this.trafficTask, this.trafficPeriod, this.trafficPeriod);
        } else {
            log.debug("(protected intent task already running)");
        }
    }

    private synchronized void cancelTask() {
        if (this.trafficTask != null) {
            this.trafficTask.cancel();
            this.trafficTask = null;
        }
    }

    private void sendSelectedIntents() {
        log.debug("sendSelectedIntents: {}", (Object)this.selectedIntent);
        this.msgHandler.sendHighlights(this.protectedIntentHighlights());
    }

    private void sendClearHighlights() {
        log.debug("sendClearHighlights");
        this.msgHandler.sendHighlights(new Highlights());
    }

    private Highlights protectedIntentHighlights() {
        Highlights highlights = new Highlights();
        TrafficLinkMap linkMap = new TrafficLinkMap();
        IntentService intentService = this.services.intent();
        if (this.selectedIntent != null) {
            List installables = intentService.getInstallableIntents(this.selectedIntent.key());
            if (installables != null) {
                ProtectionEndpointIntent ep1 = installables.stream().filter(ProtectionEndpointIntent.class::isInstance).map(ProtectionEndpointIntent.class::cast).findFirst().orElse(null);
                ProtectionEndpointIntent ep2 = installables.stream().filter(ii -> !ii.equals((Object)ep1)).filter(ProtectionEndpointIntent.class::isInstance).map(ProtectionEndpointIntent.class::cast).findFirst().orElse(null);
                if (ep1 == null || ep2 == null) {
                    log.warn("Selected Intent {} didn't have 2 protection endpoints", (Object)this.selectedIntent.key());
                    this.stopMonitoring();
                    return highlights;
                }
                LinkedHashSet primary = new LinkedHashSet();
                LinkedHashSet backup = new LinkedHashSet();
                Map<Boolean, List<FlowRuleIntent>> transits = installables.stream().filter(FlowRuleIntent.class::isInstance).map(FlowRuleIntent.class::cast).collect(Collectors.groupingBy(arg_0 -> this.isPrimary(arg_0)));
                ConnectPoint primHead = ((TransportEndpointDescription)ep1.description().paths().get(0)).output().connectPoint();
                ConnectPoint primTail = ((TransportEndpointDescription)ep2.description().paths().get(0)).output().connectPoint();
                List<FlowRuleIntent> primTransit = transits.getOrDefault(true, (List<FlowRuleIntent>)ImmutableList.of());
                this.populateLinks(primary, primHead, primTail, primTransit);
                ConnectPoint backHead = ((TransportEndpointDescription)ep1.description().paths().get(1)).output().connectPoint();
                ConnectPoint backTail = ((TransportEndpointDescription)ep2.description().paths().get(1)).output().connectPoint();
                List<FlowRuleIntent> backTransit = transits.getOrDefault(false, (List<FlowRuleIntent>)ImmutableList.of());
                this.populateLinks(backup, backHead, backTail, backTransit);
                if (!this.usingBackup(primary)) {
                    primary.addAll(this.protectedIntentMultiLayer(primHead, primTail));
                }
                backup.addAll(this.protectedIntentMultiLayer(backHead, backTail));
                boolean isOptical = this.selectedIntent instanceof OpticalConnectivityIntent;
                if (this.usingBackup(primary)) {
                    this.processLinks(linkMap, backup, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, isOptical, true, PROTECTED_MOD_BACKUP_SET);
                } else {
                    this.processLinks(linkMap, primary, LinkHighlight.Flavor.PRIMARY_HIGHLIGHT, isOptical, true, PROTECTED_MOD_PRIMARY_SET);
                    this.processLinks(linkMap, backup, LinkHighlight.Flavor.SECONDARY_HIGHLIGHT, isOptical, false, PROTECTED_MOD_BACKUP_SET);
                }
                this.updateHighlights(highlights, primary);
                this.updateHighlights(highlights, backup);
                this.colorLinks(highlights, linkMap);
                highlights.subdueAllElse(Highlights.Amount.MINIMALLY);
            } else {
                log.debug("Selected Intent has no installable intents");
            }
        } else {
            log.debug("Selected Intent is null");
        }
        return highlights;
    }

    private Set<Link> protectedIntentMultiLayer(ConnectPoint head, ConnectPoint tail) {
        LinkedList links = new LinkedList();
        LinkService linkService = this.services.link();
        IntentService intentService = this.services.intent();
        links.addAll(linkService.getEgressLinks(head).stream().filter(l -> l.type() == Link.Type.OPTICAL).collect(Collectors.toList()));
        links.addAll(linkService.getIngressLinks(tail).stream().filter(l -> l.type() == Link.Type.OPTICAL).collect(Collectors.toList()));
        if (links.size() != 2) {
            return Collections.emptySet();
        }
        ConnectPoint ocHead = ((Link)links.get(0)).dst();
        ConnectPoint ocTail = ((Link)links.get(1)).src();
        intentService.getIntents().forEach(intent -> {
            if (intent instanceof OpticalConnectivityIntent) {
                OpticalConnectivityIntent ocIntent = (OpticalConnectivityIntent)intent;
                if (ocHead.deviceId().equals((Object)ocIntent.getSrc().deviceId()) && ocTail.deviceId().equals((Object)ocIntent.getDst().deviceId())) {
                    intentService.getInstallableIntents(ocIntent.key()).forEach(i -> {
                        if (i instanceof FlowRuleIntent) {
                            FlowRuleIntent fr = (FlowRuleIntent)i;
                            links.addAll(this.linkResources((Intent)fr));
                        }
                    });
                }
            }
        });
        return new LinkedHashSet<Link>(links);
    }

    private void populateLinks(Set<Link> links, ConnectPoint head, ConnectPoint tail, List<FlowRuleIntent> transit) {
        Link first = transit.stream().flatMap(fri -> fri.flowRules().stream()).map(fr -> Optional.ofNullable(fr.selector().getCriterion(Criterion.Type.IN_PORT)).filter(PortCriterion.class::isInstance).map(PortCriterion.class::cast).map(PortCriterion::port).map(pn -> new ConnectPoint((ElementId)fr.deviceId(), pn)).orElse(null)).filter(Objects::nonNull).map(dst -> this.services.link().getLink(head, dst)).filter(Objects::nonNull).findFirst().orElse(this.services.link().getLink(head, tail));
        if (first != null) {
            links.add(first);
        }
        transit.forEach(fri -> links.addAll(this.linkResources((Intent)fri)));
        Lists.reverse(transit).stream().flatMap(fri -> ImmutableList.copyOf((Collection)fri.flowRules()).reverse().stream()).map(fr -> fr.treatment().allInstructions().stream().filter(Instructions.OutputInstruction.class::isInstance).findFirst().map(Instructions.OutputInstruction.class::cast).map(Instructions.OutputInstruction::port).map(pn -> new ConnectPoint((ElementId)fr.deviceId(), pn)).orElse(null)).filter(Objects::nonNull).map(src -> this.services.link().getLink(src, tail)).filter(Objects::nonNull).findFirst().ifPresent(links::add);
    }

    private boolean isPrimary(Intent intent) {
        return intent.resources().contains(MarkerResource.marker((String)PRIMARY_PATH_TAG));
    }

    private boolean usingBackup(Set<Link> primary) {
        HashSet activeLinks = Sets.newHashSet((Iterable)this.services.link().getActiveLinks());
        return primary.isEmpty() || !activeLinks.containsAll(primary);
    }

    private void updateHighlights(Highlights highlights, Iterable<Link> links) {
        for (Link link : links) {
            this.ensureNodePresent(highlights, link.src().elementId());
            this.ensureNodePresent(highlights, link.dst().elementId());
        }
    }

    private void ensureNodePresent(Highlights highlights, ElementId eid) {
        String id = eid.toString();
        NodeHighlight nh = highlights.getNode(id);
        if (nh == null) {
            if (eid instanceof DeviceId) {
                nh = new DeviceHighlight(id);
                highlights.add((DeviceHighlight)nh);
            } else if (eid instanceof HostId) {
                nh = new HostHighlight(id);
                highlights.add((HostHighlight)nh);
            }
        }
    }

    private void processLinks(TrafficLinkMap linkMap, Iterable<Link> links, LinkHighlight.Flavor flavor, boolean isOptical, boolean showTraffic, Set<Mod> mods) {
        if (links != null) {
            for (Link link : links) {
                TrafficLink tlink = (TrafficLink)linkMap.add(link);
                tlink.tagFlavor(flavor);
                tlink.optical(isOptical);
                if (showTraffic) {
                    tlink.antMarch(true);
                }
                tlink.tagMods(mods);
            }
        }
    }

    private void colorLinks(Highlights highlights, TrafficLinkMap linkMap) {
        for (TrafficLink tlink : linkMap.biLinks()) {
            highlights.add(tlink.highlight((Enum)TrafficLink.StatsType.TAGGED));
        }
    }

    private Collection<Link> linkResources(Intent installable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        installable.resources().stream().filter(r -> r instanceof Link).forEach(r -> builder.add((Object)((Link)r)));
        return builder.build();
    }

    static /* synthetic */ ProtectedMode access$100(ProtectedIntentMonitor x0) {
        return x0.mode;
    }

    static /* synthetic */ void access$200(ProtectedIntentMonitor x0) {
        x0.sendSelectedIntents();
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }
}

